/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.eks.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.eks.model.transform.AddonPodIdentityConfigurationMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class AddonPodIdentityConfiguration
implements Serializable,
Cloneable,
StructuredPojo {
    private String serviceAccount;
    private List<String> recommendedManagedPolicies;

    public void setServiceAccount(String serviceAccount) {
        this.serviceAccount = serviceAccount;
    }

    public String getServiceAccount() {
        return this.serviceAccount;
    }

    public AddonPodIdentityConfiguration withServiceAccount(String serviceAccount) {
        this.setServiceAccount(serviceAccount);
        return this;
    }

    public List<String> getRecommendedManagedPolicies() {
        return this.recommendedManagedPolicies;
    }

    public void setRecommendedManagedPolicies(Collection<String> recommendedManagedPolicies) {
        if (recommendedManagedPolicies == null) {
            this.recommendedManagedPolicies = null;
            return;
        }
        this.recommendedManagedPolicies = new ArrayList<String>(recommendedManagedPolicies);
    }

    public AddonPodIdentityConfiguration withRecommendedManagedPolicies(String ... recommendedManagedPolicies) {
        if (this.recommendedManagedPolicies == null) {
            this.setRecommendedManagedPolicies(new ArrayList<String>(recommendedManagedPolicies.length));
        }
        for (String ele : recommendedManagedPolicies) {
            this.recommendedManagedPolicies.add(ele);
        }
        return this;
    }

    public AddonPodIdentityConfiguration withRecommendedManagedPolicies(Collection<String> recommendedManagedPolicies) {
        this.setRecommendedManagedPolicies(recommendedManagedPolicies);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getServiceAccount() != null) {
            sb.append("ServiceAccount: ").append(this.getServiceAccount()).append(",");
        }
        if (this.getRecommendedManagedPolicies() != null) {
            sb.append("RecommendedManagedPolicies: ").append(this.getRecommendedManagedPolicies());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AddonPodIdentityConfiguration)) {
            return false;
        }
        AddonPodIdentityConfiguration other = (AddonPodIdentityConfiguration)obj;
        if (other.getServiceAccount() == null ^ this.getServiceAccount() == null) {
            return false;
        }
        if (other.getServiceAccount() != null && !other.getServiceAccount().equals(this.getServiceAccount())) {
            return false;
        }
        if (other.getRecommendedManagedPolicies() == null ^ this.getRecommendedManagedPolicies() == null) {
            return false;
        }
        return other.getRecommendedManagedPolicies() == null || other.getRecommendedManagedPolicies().equals(this.getRecommendedManagedPolicies());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getServiceAccount() == null ? 0 : this.getServiceAccount().hashCode());
        hashCode = 31 * hashCode + (this.getRecommendedManagedPolicies() == null ? 0 : this.getRecommendedManagedPolicies().hashCode());
        return hashCode;
    }

    public AddonPodIdentityConfiguration clone() {
        try {
            return (AddonPodIdentityConfiguration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        AddonPodIdentityConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

