/*
 * Copyright 2020-2025 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.ecs.model.transform;

import javax.annotation.Generated;

import com.amazonaws.SdkClientException;
import com.amazonaws.services.ecs.model.*;

import com.amazonaws.protocol.*;
import com.amazonaws.annotation.SdkInternalApi;

/**
 * ManagedScalingMarshaller
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
@SdkInternalApi
public class ManagedScalingMarshaller {

    private static final MarshallingInfo<String> STATUS_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("status").build();
    private static final MarshallingInfo<Integer> TARGETCAPACITY_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("targetCapacity").build();
    private static final MarshallingInfo<Integer> MINIMUMSCALINGSTEPSIZE_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("minimumScalingStepSize").build();
    private static final MarshallingInfo<Integer> MAXIMUMSCALINGSTEPSIZE_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("maximumScalingStepSize").build();
    private static final MarshallingInfo<Integer> INSTANCEWARMUPPERIOD_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("instanceWarmupPeriod").build();

    private static final ManagedScalingMarshaller instance = new ManagedScalingMarshaller();

    public static ManagedScalingMarshaller getInstance() {
        return instance;
    }

    /**
     * Marshall the given parameter object.
     */
    public void marshall(ManagedScaling managedScaling, ProtocolMarshaller protocolMarshaller) {

        if (managedScaling == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        try {
            protocolMarshaller.marshall(managedScaling.getStatus(), STATUS_BINDING);
            protocolMarshaller.marshall(managedScaling.getTargetCapacity(), TARGETCAPACITY_BINDING);
            protocolMarshaller.marshall(managedScaling.getMinimumScalingStepSize(), MINIMUMSCALINGSTEPSIZE_BINDING);
            protocolMarshaller.marshall(managedScaling.getMaximumScalingStepSize(), MAXIMUMSCALINGSTEPSIZE_BINDING);
            protocolMarshaller.marshall(managedScaling.getInstanceWarmupPeriod(), INSTANCEWARMUPPERIOD_BINDING);
        } catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }

}
