/*
 * Copyright 2020-2025 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.databasemigrationservice.model;

import java.io.Serializable;
import javax.annotation.Generated;

/**
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/RunFleetAdvisorLsaAnalysis" target="_top">AWS API
 *      Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class RunFleetAdvisorLsaAnalysisResult extends com.amazonaws.AmazonWebServiceResult<com.amazonaws.ResponseMetadata> implements Serializable, Cloneable {

    /**
     * <p>
     * The ID of the LSA analysis run.
     * </p>
     */
    private String lsaAnalysisId;
    /**
     * <p>
     * The status of the LSA analysis, for example <code>COMPLETED</code>.
     * </p>
     */
    private String status;

    /**
     * <p>
     * The ID of the LSA analysis run.
     * </p>
     * 
     * @param lsaAnalysisId
     *        The ID of the LSA analysis run.
     */

    public void setLsaAnalysisId(String lsaAnalysisId) {
        this.lsaAnalysisId = lsaAnalysisId;
    }

    /**
     * <p>
     * The ID of the LSA analysis run.
     * </p>
     * 
     * @return The ID of the LSA analysis run.
     */

    public String getLsaAnalysisId() {
        return this.lsaAnalysisId;
    }

    /**
     * <p>
     * The ID of the LSA analysis run.
     * </p>
     * 
     * @param lsaAnalysisId
     *        The ID of the LSA analysis run.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public RunFleetAdvisorLsaAnalysisResult withLsaAnalysisId(String lsaAnalysisId) {
        setLsaAnalysisId(lsaAnalysisId);
        return this;
    }

    /**
     * <p>
     * The status of the LSA analysis, for example <code>COMPLETED</code>.
     * </p>
     * 
     * @param status
     *        The status of the LSA analysis, for example <code>COMPLETED</code>.
     */

    public void setStatus(String status) {
        this.status = status;
    }

    /**
     * <p>
     * The status of the LSA analysis, for example <code>COMPLETED</code>.
     * </p>
     * 
     * @return The status of the LSA analysis, for example <code>COMPLETED</code>.
     */

    public String getStatus() {
        return this.status;
    }

    /**
     * <p>
     * The status of the LSA analysis, for example <code>COMPLETED</code>.
     * </p>
     * 
     * @param status
     *        The status of the LSA analysis, for example <code>COMPLETED</code>.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public RunFleetAdvisorLsaAnalysisResult withStatus(String status) {
        setStatus(status);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getLsaAnalysisId() != null)
            sb.append("LsaAnalysisId: ").append(getLsaAnalysisId()).append(",");
        if (getStatus() != null)
            sb.append("Status: ").append(getStatus());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof RunFleetAdvisorLsaAnalysisResult == false)
            return false;
        RunFleetAdvisorLsaAnalysisResult other = (RunFleetAdvisorLsaAnalysisResult) obj;
        if (other.getLsaAnalysisId() == null ^ this.getLsaAnalysisId() == null)
            return false;
        if (other.getLsaAnalysisId() != null && other.getLsaAnalysisId().equals(this.getLsaAnalysisId()) == false)
            return false;
        if (other.getStatus() == null ^ this.getStatus() == null)
            return false;
        if (other.getStatus() != null && other.getStatus().equals(this.getStatus()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getLsaAnalysisId() == null) ? 0 : getLsaAnalysisId().hashCode());
        hashCode = prime * hashCode + ((getStatus() == null) ? 0 : getStatus().hashCode());
        return hashCode;
    }

    @Override
    public RunFleetAdvisorLsaAnalysisResult clone() {
        try {
            return (RunFleetAdvisorLsaAnalysisResult) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

}
