/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dlm.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.dlm.model.EventParameters;
import com.amazonaws.services.dlm.model.EventSourceValues;
import com.amazonaws.services.dlm.model.transform.EventSourceMarshaller;
import java.io.Serializable;

public class EventSource
implements Serializable,
Cloneable,
StructuredPojo {
    private String type;
    private EventParameters parameters;

    public void setType(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public EventSource withType(String type) {
        this.setType(type);
        return this;
    }

    public EventSource withType(EventSourceValues type) {
        this.type = type.toString();
        return this;
    }

    public void setParameters(EventParameters parameters) {
        this.parameters = parameters;
    }

    public EventParameters getParameters() {
        return this.parameters;
    }

    public EventSource withParameters(EventParameters parameters) {
        this.setParameters(parameters);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getType() != null) {
            sb.append("Type: ").append(this.getType()).append(",");
        }
        if (this.getParameters() != null) {
            sb.append("Parameters: ").append(this.getParameters());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EventSource)) {
            return false;
        }
        EventSource other = (EventSource)obj;
        if (other.getType() == null ^ this.getType() == null) {
            return false;
        }
        if (other.getType() != null && !other.getType().equals(this.getType())) {
            return false;
        }
        if (other.getParameters() == null ^ this.getParameters() == null) {
            return false;
        }
        return other.getParameters() == null || other.getParameters().equals(this.getParameters());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getType() == null ? 0 : this.getType().hashCode());
        hashCode = 31 * hashCode + (this.getParameters() == null ? 0 : this.getParameters().hashCode());
        return hashCode;
    }

    public EventSource clone() {
        try {
            return (EventSource)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        EventSourceMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

