/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.controltower.model;

import com.amazonaws.AmazonWebServiceRequest;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class EnableControlRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String controlIdentifier;
    private Map<String, String> tags;
    private String targetIdentifier;

    public void setControlIdentifier(String controlIdentifier) {
        this.controlIdentifier = controlIdentifier;
    }

    public String getControlIdentifier() {
        return this.controlIdentifier;
    }

    public EnableControlRequest withControlIdentifier(String controlIdentifier) {
        this.setControlIdentifier(controlIdentifier);
        return this;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public void setTags(Map<String, String> tags) {
        this.tags = tags;
    }

    public EnableControlRequest withTags(Map<String, String> tags) {
        this.setTags(tags);
        return this;
    }

    public EnableControlRequest addTagsEntry(String key, String value) {
        if (null == this.tags) {
            this.tags = new HashMap<String, String>();
        }
        if (this.tags.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.tags.put(key, value);
        return this;
    }

    public EnableControlRequest clearTagsEntries() {
        this.tags = null;
        return this;
    }

    public void setTargetIdentifier(String targetIdentifier) {
        this.targetIdentifier = targetIdentifier;
    }

    public String getTargetIdentifier() {
        return this.targetIdentifier;
    }

    public EnableControlRequest withTargetIdentifier(String targetIdentifier) {
        this.setTargetIdentifier(targetIdentifier);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getControlIdentifier() != null) {
            sb.append("ControlIdentifier: ").append(this.getControlIdentifier()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags()).append(",");
        }
        if (this.getTargetIdentifier() != null) {
            sb.append("TargetIdentifier: ").append(this.getTargetIdentifier());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EnableControlRequest)) {
            return false;
        }
        EnableControlRequest other = (EnableControlRequest)obj;
        if (other.getControlIdentifier() == null ^ this.getControlIdentifier() == null) {
            return false;
        }
        if (other.getControlIdentifier() != null && !other.getControlIdentifier().equals(this.getControlIdentifier())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        if (other.getTags() != null && !other.getTags().equals(this.getTags())) {
            return false;
        }
        if (other.getTargetIdentifier() == null ^ this.getTargetIdentifier() == null) {
            return false;
        }
        return other.getTargetIdentifier() == null || other.getTargetIdentifier().equals(this.getTargetIdentifier());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getControlIdentifier() == null ? 0 : this.getControlIdentifier().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        hashCode = 31 * hashCode + (this.getTargetIdentifier() == null ? 0 : this.getTargetIdentifier().hashCode());
        return hashCode;
    }

    public EnableControlRequest clone() {
        return (EnableControlRequest)super.clone();
    }
}

