/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codedeploy.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.codedeploy.model.BatchGetApplicationRevisionsRequest;
import com.amazonaws.services.codedeploy.model.RevisionLocation;
import com.amazonaws.services.codedeploy.model.transform.RevisionLocationJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class BatchGetApplicationRevisionsRequestMarshaller
implements Marshaller<Request<BatchGetApplicationRevisionsRequest>, BatchGetApplicationRevisionsRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public BatchGetApplicationRevisionsRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<BatchGetApplicationRevisionsRequest> marshall(BatchGetApplicationRevisionsRequest batchGetApplicationRevisionsRequest) {
        if (batchGetApplicationRevisionsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)batchGetApplicationRevisionsRequest, "AmazonCodeDeploy");
        request.addHeader("X-Amz-Target", "CodeDeploy_20141006.BatchGetApplicationRevisions");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            SdkInternalList revisionsList;
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (batchGetApplicationRevisionsRequest.getApplicationName() != null) {
                jsonGenerator.writeFieldName("applicationName").writeValue(batchGetApplicationRevisionsRequest.getApplicationName());
            }
            if (!(revisionsList = (SdkInternalList)batchGetApplicationRevisionsRequest.getRevisions()).isEmpty() || !revisionsList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("revisions");
                jsonGenerator.writeStartArray();
                for (RevisionLocation revisionsListValue : revisionsList) {
                    if (revisionsListValue == null) continue;
                    RevisionLocationJsonMarshaller.getInstance().marshall(revisionsListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

