/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ask.model.interfaces.gameEngine;

import com.amazon.ask.model.Request;
import com.amazon.ask.model.services.gameEngine.InputHandlerEvent;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonDeserialize(builder=Builder.class)
public final class InputHandlerEventRequest
extends Request {
    @JsonProperty(value="originatingRequestId")
    private String originatingRequestId = null;
    @JsonProperty(value="events")
    private List<InputHandlerEvent> events = new ArrayList<InputHandlerEvent>();

    private InputHandlerEventRequest() {
    }

    public static Builder builder() {
        return new Builder();
    }

    private InputHandlerEventRequest(Builder builder) {
        String discriminatorValue;
        this.type = discriminatorValue = "GameEngine.InputHandlerEvent";
        if (builder.requestId != null) {
            this.requestId = builder.requestId;
        }
        if (builder.timestamp != null) {
            this.timestamp = builder.timestamp;
        }
        if (builder.locale != null) {
            this.locale = builder.locale;
        }
        if (builder.originatingRequestId != null) {
            this.originatingRequestId = builder.originatingRequestId;
        }
        if (builder.events != null) {
            this.events = builder.events;
        }
    }

    @JsonProperty(value="originatingRequestId")
    public String getOriginatingRequestId() {
        return this.originatingRequestId;
    }

    @JsonProperty(value="events")
    public List<InputHandlerEvent> getEvents() {
        return this.events;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InputHandlerEventRequest interfacesGameEngineInputHandlerEventRequest = (InputHandlerEventRequest)o;
        return Objects.equals(this.originatingRequestId, interfacesGameEngineInputHandlerEventRequest.originatingRequestId) && Objects.equals(this.events, interfacesGameEngineInputHandlerEventRequest.events) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.originatingRequestId, this.events, super.hashCode());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class InputHandlerEventRequest {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    originatingRequestId: ").append(this.toIndentedString(this.originatingRequestId)).append("\n");
        sb.append("    events: ").append(this.toIndentedString(this.events)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static class Builder {
        private String requestId;
        private OffsetDateTime timestamp;
        private String locale;
        private String originatingRequestId;
        private List<InputHandlerEvent> events;

        private Builder() {
        }

        @JsonProperty(value="requestId")
        public Builder withRequestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        @JsonProperty(value="timestamp")
        public Builder withTimestamp(OffsetDateTime timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        @JsonProperty(value="locale")
        public Builder withLocale(String locale) {
            this.locale = locale;
            return this;
        }

        @JsonProperty(value="originatingRequestId")
        public Builder withOriginatingRequestId(String originatingRequestId) {
            this.originatingRequestId = originatingRequestId;
            return this;
        }

        @JsonProperty(value="events")
        public Builder withEvents(List<InputHandlerEvent> events) {
            this.events = events;
            return this;
        }

        public Builder addEventsItem(InputHandlerEvent eventsItem) {
            if (this.events == null) {
                this.events = new ArrayList<InputHandlerEvent>();
            }
            this.events.add(eventsItem);
            return this;
        }

        public InputHandlerEventRequest build() {
            return new InputHandlerEventRequest(this);
        }
    }
}

