/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ask.model.interfaces.connections;

import com.amazon.ask.model.Request;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@JsonDeserialize(builder=Builder.class)
public final class ConnectionsRequest
extends Request {
    @JsonProperty(value="name")
    private String name = null;
    @JsonProperty(value="payload")
    private Map<String, Object> payload = new HashMap<String, Object>();

    private ConnectionsRequest() {
    }

    public static Builder builder() {
        return new Builder();
    }

    private ConnectionsRequest(Builder builder) {
        String discriminatorValue;
        this.type = discriminatorValue = "Connections.Request";
        if (builder.requestId != null) {
            this.requestId = builder.requestId;
        }
        if (builder.timestamp != null) {
            this.timestamp = builder.timestamp;
        }
        if (builder.locale != null) {
            this.locale = builder.locale;
        }
        if (builder.name != null) {
            this.name = builder.name;
        }
        if (builder.payload != null) {
            this.payload = builder.payload;
        }
    }

    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="payload")
    public Map<String, Object> getPayload() {
        return this.payload;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConnectionsRequest interfacesConnectionsConnectionsRequest = (ConnectionsRequest)o;
        return Objects.equals(this.name, interfacesConnectionsConnectionsRequest.name) && Objects.equals(this.payload, interfacesConnectionsConnectionsRequest.payload) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.name, this.payload, super.hashCode());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ConnectionsRequest {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    payload: ").append(this.toIndentedString(this.payload)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static class Builder {
        private String requestId;
        private OffsetDateTime timestamp;
        private String locale;
        private String name;
        private Map<String, Object> payload;

        private Builder() {
        }

        @JsonProperty(value="requestId")
        public Builder withRequestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        @JsonProperty(value="timestamp")
        public Builder withTimestamp(OffsetDateTime timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        @JsonProperty(value="locale")
        public Builder withLocale(String locale) {
            this.locale = locale;
            return this;
        }

        @JsonProperty(value="name")
        public Builder withName(String name) {
            this.name = name;
            return this;
        }

        @JsonProperty(value="payload")
        public Builder withPayload(Map<String, Object> payload) {
            this.payload = payload;
            return this;
        }

        public Builder putPayloadItem(String key, Object payloadItem) {
            if (this.payload == null) {
                this.payload = new HashMap<String, Object>();
            }
            this.payload.put(key, payloadItem);
            return this;
        }

        public ConnectionsRequest build() {
            return new ConnectionsRequest(this);
        }
    }
}

