/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ask.model.interfaces.alexa.presentation.apl;

import com.amazon.ask.model.interfaces.alexa.presentation.apl.AudioTrack;
import com.amazon.ask.model.interfaces.alexa.presentation.apl.Command;
import com.amazon.ask.model.interfaces.alexa.presentation.apl.VideoSource;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonDeserialize(builder=Builder.class)
public final class PlayMediaCommand
extends Command {
    @JsonProperty(value="audioTrack")
    private AudioTrack audioTrack = null;
    @JsonProperty(value="componentId")
    private String componentId = null;
    @JsonProperty(value="source")
    private List<VideoSource> source = new ArrayList<VideoSource>();

    private PlayMediaCommand() {
    }

    public static Builder builder() {
        return new Builder();
    }

    private PlayMediaCommand(Builder builder) {
        String discriminatorValue;
        this.type = discriminatorValue = "PlayMedia";
        if (builder.delay != null) {
            this.delay = builder.delay;
        }
        if (builder.description != null) {
            this.description = builder.description;
        }
        if (builder.screenLock != null) {
            this.screenLock = builder.screenLock;
        }
        if (builder.sequencer != null) {
            this.sequencer = builder.sequencer;
        }
        if (builder.when != null) {
            this.when = builder.when;
        }
        if (builder.audioTrack != null) {
            this.audioTrack = builder.audioTrack;
        }
        if (builder.componentId != null) {
            this.componentId = builder.componentId;
        }
        if (builder.source != null) {
            this.source = builder.source;
        }
    }

    @JsonProperty(value="audioTrack")
    public AudioTrack getAudioTrack() {
        return this.audioTrack;
    }

    @JsonProperty(value="componentId")
    public String getComponentId() {
        return this.componentId;
    }

    @JsonProperty(value="source")
    public List<VideoSource> getSource() {
        return this.source;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PlayMediaCommand interfacesAlexaPresentationAplPlayMediaCommand = (PlayMediaCommand)o;
        return Objects.equals((Object)this.audioTrack, (Object)interfacesAlexaPresentationAplPlayMediaCommand.audioTrack) && Objects.equals(this.componentId, interfacesAlexaPresentationAplPlayMediaCommand.componentId) && Objects.equals(this.source, interfacesAlexaPresentationAplPlayMediaCommand.source) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.audioTrack, this.componentId, this.source, super.hashCode()});
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PlayMediaCommand {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    audioTrack: ").append(this.toIndentedString((Object)this.audioTrack)).append("\n");
        sb.append("    componentId: ").append(this.toIndentedString(this.componentId)).append("\n");
        sb.append("    source: ").append(this.toIndentedString(this.source)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static class Builder {
        private String delay;
        private String description;
        private Boolean screenLock;
        private String sequencer;
        private Boolean when;
        private AudioTrack audioTrack;
        private String componentId;
        private List<VideoSource> source;

        private Builder() {
        }

        @JsonProperty(value="delay")
        public Builder withDelay(Integer delay) {
            this.delay = String.valueOf(delay);
            return this;
        }

        @JsonProperty(value="delay")
        public Builder withDelay(String delayExpression) {
            this.delay = delayExpression;
            return this;
        }

        @JsonProperty(value="description")
        public Builder withDescription(String description) {
            this.description = description;
            return this;
        }

        @JsonProperty(value="screenLock")
        public Builder withScreenLock(Boolean screenLock) {
            this.screenLock = screenLock;
            return this;
        }

        @JsonProperty(value="sequencer")
        public Builder withSequencer(String sequencer) {
            this.sequencer = sequencer;
            return this;
        }

        @JsonProperty(value="when")
        public Builder withWhen(Boolean when) {
            this.when = when;
            return this;
        }

        @JsonProperty(value="audioTrack")
        public Builder withAudioTrack(AudioTrack audioTrack) {
            this.audioTrack = audioTrack;
            return this;
        }

        @JsonProperty(value="componentId")
        public Builder withComponentId(String componentId) {
            this.componentId = componentId;
            return this;
        }

        @JsonProperty(value="source")
        public Builder withSource(List<VideoSource> source) {
            this.source = source;
            return this;
        }

        public Builder addSourceItem(VideoSource sourceItem) {
            if (this.source == null) {
                this.source = new ArrayList<VideoSource>();
            }
            this.source.add(sourceItem);
            return this;
        }

        public PlayMediaCommand build() {
            return new PlayMediaCommand(this);
        }
    }
}

