/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ask.model.interfaces.alexa.datastore.packagemanager;

import com.amazon.ask.model.Request;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.time.OffsetDateTime;
import java.util.Objects;

@JsonDeserialize(builder=Builder.class)
public final class UpdateRequest
extends Request {
    @JsonProperty(value="packageId")
    private String packageId = null;
    @JsonProperty(value="fromVersion")
    private String fromVersion = null;
    @JsonProperty(value="toVersion")
    private String toVersion = null;

    private UpdateRequest() {
    }

    public static Builder builder() {
        return new Builder();
    }

    private UpdateRequest(Builder builder) {
        String discriminatorValue;
        this.type = discriminatorValue = "Alexa.DataStore.PackageManager.UpdateRequest";
        if (builder.requestId != null) {
            this.requestId = builder.requestId;
        }
        if (builder.timestamp != null) {
            this.timestamp = builder.timestamp;
        }
        if (builder.locale != null) {
            this.locale = builder.locale;
        }
        if (builder.packageId != null) {
            this.packageId = builder.packageId;
        }
        if (builder.fromVersion != null) {
            this.fromVersion = builder.fromVersion;
        }
        if (builder.toVersion != null) {
            this.toVersion = builder.toVersion;
        }
    }

    @JsonProperty(value="packageId")
    public String getPackageId() {
        return this.packageId;
    }

    @JsonProperty(value="fromVersion")
    public String getFromVersion() {
        return this.fromVersion;
    }

    @JsonProperty(value="toVersion")
    public String getToVersion() {
        return this.toVersion;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UpdateRequest interfacesAlexaDatastorePackagemanagerUpdateRequest = (UpdateRequest)o;
        return Objects.equals(this.packageId, interfacesAlexaDatastorePackagemanagerUpdateRequest.packageId) && Objects.equals(this.fromVersion, interfacesAlexaDatastorePackagemanagerUpdateRequest.fromVersion) && Objects.equals(this.toVersion, interfacesAlexaDatastorePackagemanagerUpdateRequest.toVersion) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.packageId, this.fromVersion, this.toVersion, super.hashCode());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UpdateRequest {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    packageId: ").append(this.toIndentedString(this.packageId)).append("\n");
        sb.append("    fromVersion: ").append(this.toIndentedString(this.fromVersion)).append("\n");
        sb.append("    toVersion: ").append(this.toIndentedString(this.toVersion)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static class Builder {
        private String requestId;
        private OffsetDateTime timestamp;
        private String locale;
        private String packageId;
        private String fromVersion;
        private String toVersion;

        private Builder() {
        }

        @JsonProperty(value="requestId")
        public Builder withRequestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        @JsonProperty(value="timestamp")
        public Builder withTimestamp(OffsetDateTime timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        @JsonProperty(value="locale")
        public Builder withLocale(String locale) {
            this.locale = locale;
            return this;
        }

        @JsonProperty(value="packageId")
        public Builder withPackageId(String packageId) {
            this.packageId = packageId;
            return this;
        }

        @JsonProperty(value="fromVersion")
        public Builder withFromVersion(String fromVersion) {
            this.fromVersion = fromVersion;
            return this;
        }

        @JsonProperty(value="toVersion")
        public Builder withToVersion(String toVersion) {
            this.toVersion = toVersion;
            return this;
        }

        public UpdateRequest build() {
            return new UpdateRequest(this);
        }
    }
}

