/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ask.model.authorization;

import com.amazon.ask.model.authorization.GrantType;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Objects;

@JsonDeserialize(builder=Builder.class)
public final class Grant {
    @JsonProperty(value="type")
    private String type = null;
    @JsonProperty(value="code")
    private String code = null;

    private Grant() {
    }

    public static Builder builder() {
        return new Builder();
    }

    private Grant(Builder builder) {
        if (builder.type != null) {
            this.type = builder.type;
        }
        if (builder.code != null) {
            this.code = builder.code;
        }
    }

    public GrantType getType() {
        return GrantType.fromValue(this.type);
    }

    @JsonProperty(value="type")
    public String getTypeAsString() {
        return this.type;
    }

    @JsonProperty(value="code")
    public String getCode() {
        return this.code;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Grant authorizationGrant = (Grant)o;
        return Objects.equals(this.type, authorizationGrant.type) && Objects.equals(this.code, authorizationGrant.code);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.code);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Grant {\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    code: ").append(this.toIndentedString(this.code)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static class Builder {
        private String type;
        private String code;

        private Builder() {
        }

        @JsonProperty(value="type")
        public Builder withType(String type) {
            this.type = type;
            return this;
        }

        public Builder withType(GrantType type) {
            this.type = type != null ? type.toString() : null;
            return this;
        }

        @JsonProperty(value="code")
        public Builder withCode(String code) {
            this.code = code;
            return this;
        }

        public Grant build() {
            return new Grant(this);
        }
    }
}

