/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.speech.speechlet.interfaces.core;

import com.amazon.speech.speechlet.SpeechletRequest;
import com.amazon.speech.speechlet.interfaces.core.AlexaSkillEventRequest;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.Date;
import java.util.Locale;

@JsonTypeName(value="AlexaSkillEvent.SkillEnabled")
public class SkillEnabledEventRequest
extends AlexaSkillEventRequest {
    private final Date eventCreationTime;
    private final Date eventPublishingTime;

    protected SkillEnabledEventRequest(Builder builder) {
        super(builder);
        this.eventCreationTime = builder.eventCreationTime;
        this.eventPublishingTime = builder.eventPublishingTime;
    }

    public static Builder builder() {
        return new Builder();
    }

    private SkillEnabledEventRequest(@JsonProperty(value="requestId") String requestId, @JsonProperty(value="timestamp") Date timestamp, @JsonProperty(value="locale") Locale locale, @JsonProperty(value="eventCreationTime") Date eventCreationTime, @JsonProperty(value="eventPublishingTime") Date eventPublishingTime) {
        super(requestId, timestamp, locale);
        this.eventCreationTime = eventCreationTime;
        this.eventPublishingTime = eventPublishingTime;
    }

    public Date getEventCreationTime() {
        return new Date(this.eventCreationTime.getTime());
    }

    public Date getEventPublishingTime() {
        return new Date(this.eventPublishingTime.getTime());
    }

    public static final class Builder
    extends SpeechletRequest.SpeechletRequestBuilder<Builder, SkillEnabledEventRequest> {
        private Date eventCreationTime;
        private Date eventPublishingTime;

        private Builder() {
        }

        public Builder withEventCreationTime(Date eventCreationTime) {
            this.eventCreationTime = new Date(eventCreationTime.getTime());
            return this;
        }

        public Builder withEventPublishingTime(Date eventPublishingTime) {
            this.eventPublishingTime = new Date(eventPublishingTime.getTime());
            return this;
        }

        @Override
        public SkillEnabledEventRequest build() {
            return new SkillEnabledEventRequest(this);
        }
    }
}

