/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.speech.speechlet;

import com.amazon.speech.slu.Intent;
import com.amazon.speech.speechlet.CoreSpeechletRequest;
import com.amazon.speech.speechlet.SpeechletRequest;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.Date;
import java.util.Locale;
import org.apache.commons.lang3.Validate;

@JsonTypeName(value="IntentRequest")
public class IntentRequest
extends CoreSpeechletRequest {
    private final Intent intent;
    private final DialogState dialogState;

    public static Builder builder() {
        return new Builder();
    }

    private IntentRequest(Builder builder) {
        super(builder);
        this.intent = builder.intent;
        this.dialogState = builder.dialogState;
    }

    protected IntentRequest(@JsonProperty(value="requestId") String requestId, @JsonProperty(value="timestamp") Date timestamp, @JsonProperty(value="locale") Locale locale, @JsonProperty(value="intent") Intent intent, @JsonProperty(value="dialogState") DialogState dialogState) {
        super(requestId, timestamp, locale);
        this.intent = intent;
        this.dialogState = dialogState;
    }

    public Intent getIntent() {
        return this.intent;
    }

    public DialogState getDialogState() {
        return this.dialogState;
    }

    public static final class Builder
    extends SpeechletRequest.SpeechletRequestBuilder<Builder, IntentRequest> {
        private Intent intent;
        private DialogState dialogState;

        private Builder() {
        }

        public Builder withIntent(Intent intent) {
            this.intent = intent;
            return this;
        }

        public Builder withDialogState(DialogState dialogState) {
            this.dialogState = dialogState;
            return this;
        }

        @Override
        public IntentRequest build() {
            Validate.notBlank((CharSequence)this.getRequestId(), (String)"RequestId must be defined", (Object[])new Object[0]);
            return new IntentRequest(this);
        }
    }

    public static enum DialogState {
        STARTED,
        IN_PROGRESS,
        COMPLETED;

    }
}

