/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.speech.speechlet.verifier;

import com.amazon.speech.json.SpeechletRequestEnvelope;
import com.amazon.speech.speechlet.Context;
import com.amazon.speech.speechlet.Session;
import com.amazon.speech.speechlet.interfaces.system.SystemInterface;
import com.amazon.speech.speechlet.interfaces.system.SystemState;
import com.amazon.speech.speechlet.verifier.SpeechletRequestEnvelopeVerifier;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApplicationIdSpeechletRequestEnvelopeVerifier
implements SpeechletRequestEnvelopeVerifier {
    private final Set<String> supportedApplicationIds;
    private static final Logger log = LoggerFactory.getLogger(ApplicationIdSpeechletRequestEnvelopeVerifier.class);

    public ApplicationIdSpeechletRequestEnvelopeVerifier(Set<String> supportedApplicationIds) {
        this.supportedApplicationIds = Collections.unmodifiableSet(new HashSet<String>(supportedApplicationIds));
    }

    @Override
    public boolean verify(SpeechletRequestEnvelope<?> requestEnvelope) {
        boolean applicationIdIsMissingFromSession;
        if (this.supportedApplicationIds.isEmpty()) {
            log.warn("Application ID verification has been disabled, allowing request for all application IDs");
            return true;
        }
        Session session = requestEnvelope.getSession();
        boolean bl = applicationIdIsMissingFromSession = session == null || session.getApplication() == null || session.getApplication().getApplicationId() == null;
        if (!applicationIdIsMissingFromSession) {
            return this.supportedApplicationIds.contains(session.getApplication().getApplicationId());
        }
        Context context = requestEnvelope.getContext();
        if (context == null) {
            return false;
        }
        SystemState systemState = context.getState(SystemInterface.class, SystemInterface.STATE_TYPE);
        if (systemState == null || systemState.getApplication() == null || systemState.getApplication().getApplicationId() == null) {
            return false;
        }
        return this.supportedApplicationIds.contains(systemState.getApplication().getApplicationId());
    }
}

