/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.speech.speechlet.authentication;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.InvalidKeyException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.codec.binary.Base64;

public final class SpeechletRequestSignatureVerifier {
    private static final Map<String, X509Certificate> CERTIFICATE_CACHE = new ConcurrentHashMap<String, X509Certificate>();
    private static final Integer DOMAIN_NAME_SUBJECT_ALTERNATIVE_NAME_ENTRY = 2;
    private static final String VALID_SIGNING_CERT_CHAIN_PROTOCOL = "https";
    private static final String VALID_SIGNING_CERT_CHAIN_URL_HOST_NAME = "s3.amazonaws.com";
    private static final String VALID_SIGNING_CERT_CHAING_URL_PATH_PREFIX = "/echo.api/";
    private static final int UNSPECIFIED_SIGNING_CERT_CHAIN_URL_PORT_VALUE = -1;

    private SpeechletRequestSignatureVerifier() {
    }

    public static void checkRequestSignature(byte[] serializedSpeechletRequest, String baseEncoded64Signature, String signingCertificateChainUrl) {
        if (baseEncoded64Signature == null || signingCertificateChainUrl == null) {
            throw new SecurityException("Missing signature/certificate for the provided speechlet request");
        }
        try {
            X509Certificate signingCertificate;
            if (CERTIFICATE_CACHE.containsKey(signingCertificateChainUrl)) {
                signingCertificate = CERTIFICATE_CACHE.get(signingCertificateChainUrl);
                signingCertificate.checkValidity();
            } else {
                signingCertificate = SpeechletRequestSignatureVerifier.retrieveAndVerifyCertificateChain(signingCertificateChainUrl);
                CERTIFICATE_CACHE.put(signingCertificateChainUrl, signingCertificate);
            }
            Signature signature = Signature.getInstance("SHA1withRSA");
            signature.initVerify(signingCertificate.getPublicKey());
            signature.update(serializedSpeechletRequest);
            if (!signature.verify(Base64.decodeBase64((byte[])baseEncoded64Signature.getBytes("UTF-8")))) {
                throw new SecurityException("Failed to verify the signature/certificate for the provided speechlet request");
            }
        }
        catch (IOException | InvalidKeyException | NoSuchAlgorithmException | SignatureException | CertificateException ex) {
            throw new SecurityException("Failed to verify the signature/certificate for the provided speechlet request", ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static X509Certificate retrieveAndVerifyCertificateChain(String signingCertificateChainUrl) throws CertificateException {
        try (InputStream in = SpeechletRequestSignatureVerifier.getAndVerifySigningCertificateChainUrl(signingCertificateChainUrl).openStream();){
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            Collection<? extends Certificate> certificateChain = certificateFactory.generateCertificates(in);
            X509Certificate signingCertificate = (X509Certificate)certificateChain.iterator().next();
            signingCertificate.checkValidity();
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init((KeyStore)null);
            X509TrustManager x509TrustManager = null;
            for (TrustManager trustManager : trustManagerFactory.getTrustManagers()) {
                if (!(trustManager instanceof X509TrustManager)) continue;
                x509TrustManager = (X509TrustManager)trustManager;
            }
            if (x509TrustManager == null) {
                throw new IllegalStateException("No X509 TrustManager available. Unable to check certificate chain");
            }
            x509TrustManager.checkServerTrusted(certificateChain.toArray(new X509Certificate[certificateChain.size()]), "RSA");
            if (!SpeechletRequestSignatureVerifier.subjectAlernativeNameListContainsEchoSdkDomainName(signingCertificate.getSubjectAlternativeNames())) {
                throw new CertificateException("The provided certificate is not valid for the Echo SDK");
            }
            X509Certificate x509Certificate = signingCertificate;
            return x509Certificate;
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException ex) {
            throw new CertificateException("Unable to verify certificate at URL: " + signingCertificateChainUrl, ex);
        }
    }

    private static boolean subjectAlernativeNameListContainsEchoSdkDomainName(Collection<List<?>> subjectAlternativeNameEntries) {
        for (List<?> entry : subjectAlternativeNameEntries) {
            if (!(entry.get(0) instanceof Integer) || !(entry.get(1) instanceof String) || !DOMAIN_NAME_SUBJECT_ALTERNATIVE_NAME_ENTRY.equals(entry.get(0)) || !"echo-api.amazon.com".equals(entry.get(1))) continue;
            return true;
        }
        return false;
    }

    static URL getAndVerifySigningCertificateChainUrl(String signingCertificateChainUrl) throws CertificateException {
        try {
            URL url = new URI(signingCertificateChainUrl).normalize().toURL();
            if (!VALID_SIGNING_CERT_CHAIN_URL_HOST_NAME.equalsIgnoreCase(url.getHost())) {
                throw new CertificateException(String.format("SigningCertificateChainUrl [%s] does not contain the required hostname of [%s]", signingCertificateChainUrl, VALID_SIGNING_CERT_CHAIN_URL_HOST_NAME));
            }
            String path = url.getPath();
            if (!path.startsWith(VALID_SIGNING_CERT_CHAING_URL_PATH_PREFIX)) {
                throw new CertificateException(String.format("SigningCertificateChainUrl path [%s] is invalid. Expecting path to start with [%s]", signingCertificateChainUrl, VALID_SIGNING_CERT_CHAING_URL_PATH_PREFIX));
            }
            String urlProtocol = url.getProtocol();
            if (!VALID_SIGNING_CERT_CHAIN_PROTOCOL.equalsIgnoreCase(urlProtocol)) {
                throw new CertificateException(String.format("SigningCertificateChainUrl [%s] contains an unsupported protocol [%s]", signingCertificateChainUrl, urlProtocol));
            }
            int urlPort = url.getPort();
            if (urlPort != -1 && urlPort != url.getDefaultPort()) {
                throw new CertificateException(String.format("SigningCertificateChainUrl [%s] contains an invalid port [%d]", signingCertificateChainUrl, urlPort));
            }
            return url;
        }
        catch (IllegalArgumentException | MalformedURLException | URISyntaxException ex) {
            throw new CertificateException(String.format("SigningCertificateChainUrl [%s] is malformed", signingCertificateChainUrl), ex);
        }
    }
}

