/*
 * Decompiled with CFR 0.152.
 */
package org.browsermob.proxy.jetty.http;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.logging.Log;
import org.browsermob.proxy.jetty.http.HttpFields;
import org.browsermob.proxy.jetty.log.LogFactory;
import org.browsermob.proxy.jetty.util.LineInput;

public class ChunkingInputStream
extends InputStream {
    private static Log log = LogFactory.getLog(ChunkingInputStream.class);
    private static final String __UNEXPECTED_EOF = "Unexpected EOF while chunking";
    int _chunkSize = 0;
    HttpFields _trailer = null;
    LineInput _in;

    public ChunkingInputStream(LineInput in) {
        this._in = in;
    }

    public void resetStream() {
        this._chunkSize = 0;
        this._trailer = null;
    }

    @Override
    public int read() throws IOException {
        int b = -1;
        if (this._chunkSize <= 0 && this.getChunkSize() <= 0) {
            return -1;
        }
        b = this._in.read();
        if (b < 0) {
            this._chunkSize = -1;
            throw new IOException(__UNEXPECTED_EOF);
        }
        --this._chunkSize;
        return b;
    }

    @Override
    public int read(byte[] b) throws IOException {
        int len = b.length;
        if (this._chunkSize <= 0 && this.getChunkSize() <= 0) {
            return -1;
        }
        if (len > this._chunkSize) {
            len = this._chunkSize;
        }
        if ((len = this._in.read(b, 0, len)) < 0) {
            this._chunkSize = -1;
            throw new IOException(__UNEXPECTED_EOF);
        }
        this._chunkSize -= len;
        return len;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this._chunkSize <= 0 && this.getChunkSize() <= 0) {
            return -1;
        }
        if (len > this._chunkSize) {
            len = this._chunkSize;
        }
        if ((len = this._in.read(b, off, len)) < 0) {
            this._chunkSize = -1;
            throw new IOException(__UNEXPECTED_EOF);
        }
        this._chunkSize -= len;
        return len;
    }

    @Override
    public long skip(long len) throws IOException {
        if (this._chunkSize <= 0 && this.getChunkSize() <= 0) {
            return -1L;
        }
        if (len > (long)this._chunkSize) {
            len = this._chunkSize;
        }
        if ((len = this._in.skip(len)) < 0L) {
            this._chunkSize = -1;
            throw new IOException(__UNEXPECTED_EOF);
        }
        this._chunkSize -= (int)len;
        return len;
    }

    @Override
    public int available() throws IOException {
        int len = this._in.available();
        if (len <= this._chunkSize || this._chunkSize == 0) {
            return len;
        }
        return this._chunkSize;
    }

    @Override
    public void close() throws IOException {
        this._chunkSize = -1;
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public void reset() {
        log.warn((Object)"NOT IMPLEMENTED ");
    }

    @Override
    public void mark(int readlimit) {
        log.warn((Object)"NOT IMPLEMENTED ");
    }

    private int getChunkSize() throws IOException {
        if (this._chunkSize < 0) {
            return -1;
        }
        this._trailer = null;
        this._chunkSize = -1;
        LineInput.LineBuffer line_buffer = this._in.readLineBuffer();
        while (line_buffer != null && line_buffer.size == 0) {
            line_buffer = this._in.readLineBuffer();
        }
        if (line_buffer == null) {
            throw new IOException("Unexpected EOF");
        }
        String line = new String(line_buffer.buffer, 0, line_buffer.size);
        int i = line.indexOf(59);
        if (i > 0) {
            line = line.substring(0, i).trim();
        }
        try {
            this._chunkSize = Integer.parseInt(line, 16);
        }
        catch (NumberFormatException e) {
            this._chunkSize = -1;
            log.warn((Object)("Bad Chunk:" + line));
            log.debug((Object)"EXCEPTION ", (Throwable)e);
            throw new IOException("Bad chunk size");
        }
        if (this._chunkSize == 0) {
            this._chunkSize = -1;
            this._trailer = new HttpFields();
            this._trailer.read(this._in);
        }
        return this._chunkSize;
    }
}

