/*
 * Decompiled with CFR 0.152.
 */
package org.browsermob.proxy.http;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntity;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.http.message.BasicNameValuePair;
import org.browsermob.proxy.http.BrowserMobHttpClient;
import org.browsermob.proxy.http.BrowserMobHttpResponse;
import org.browsermob.proxy.http.RequestCallback;
import org.browsermob.proxy.util.Base64;
import org.browsermob.proxy.util.ClonedInputStream;
import org.browsermob.proxy.util.Log;

public class BrowserMobHttpRequest {
    private static final Log LOG = new Log();
    private HttpRequestBase method;
    private BrowserMobHttpClient client;
    private int expectedStatusCode;
    private String verificationText;
    private List<NameValuePair> nvps = new ArrayList<NameValuePair>();
    private StringEntity stringEntity;
    private ByteArrayEntity byteArrayEntity;
    private InputStreamEntity inputStreamEntity;
    private MultipartEntity multipartEntity;
    private OutputStream outputStream;
    private RequestCallback requestCallback;
    private boolean collectAdditionalInfo;
    private ByteArrayOutputStream copy;
    private String expectedLocation;
    private boolean multiPart;

    protected BrowserMobHttpRequest(HttpRequestBase method, BrowserMobHttpClient client, int expectedStatusCode, boolean collectAdditionalInfo) {
        this.method = method;
        this.client = client;
        this.expectedStatusCode = expectedStatusCode;
        this.collectAdditionalInfo = collectAdditionalInfo;
    }

    public String getExpectedLocation() {
        return this.expectedLocation;
    }

    public void setExpectedLocation(String location) {
        this.expectedLocation = location;
    }

    public void addRequestHeader(String key, String value) {
        this.method.addHeader(key, value);
    }

    public void addRequestParameter(String key, String value) {
        this.nvps.add((NameValuePair)new BasicNameValuePair(key, value));
    }

    public void setRequestBody(String body, String contentType, String charSet) {
        try {
            this.stringEntity = new StringEntity(body, charSet);
        }
        catch (UnsupportedEncodingException e) {
            try {
                this.stringEntity = new StringEntity(body, null);
            }
            catch (UnsupportedEncodingException e1) {
                // empty catch block
            }
        }
        this.stringEntity.setContentType(contentType);
    }

    public void setRequestBody(String body) {
        this.setRequestBody(body, null, "UTF-8");
    }

    public void setRequestBodyAsBase64EncodedBytes(String bodyBase64Encoded) {
        this.byteArrayEntity = new ByteArrayEntity(Base64.base64ToByteArray(bodyBase64Encoded));
    }

    public void setRequestInputStream(InputStream is, long length) {
        if (this.collectAdditionalInfo) {
            ClonedInputStream cis = new ClonedInputStream(is);
            is = cis;
            this.copy = cis.getOutput();
        }
        this.inputStreamEntity = new InputStreamEntity(is, length);
    }

    public String getVerificationText() {
        return this.verificationText;
    }

    public void setVerificationText(String verificationText) {
        this.verificationText = verificationText;
    }

    public HttpRequestBase getMethod() {
        return this.method;
    }

    public void makeMultiPart() {
        if (!this.multiPart) {
            this.multiPart = true;
            this.multipartEntity = new MultipartEntity(HttpMultipartMode.BROWSER_COMPATIBLE);
        }
    }

    public BrowserMobHttpResponse execute() {
        block14: {
            if (this.method instanceof HttpEntityEnclosingRequestBase) {
                HttpEntityEnclosingRequestBase enclodingRequest = (HttpEntityEnclosingRequestBase)this.method;
                if (!this.nvps.isEmpty()) {
                    try {
                        if (!this.multiPart) {
                            enclodingRequest.setEntity((HttpEntity)new UrlEncodedFormEntity(this.nvps, "UTF-8"));
                            break block14;
                        }
                        for (NameValuePair nvp : this.nvps) {
                            this.multipartEntity.addPart(nvp.getName(), (ContentBody)new StringBody(nvp.getValue()));
                        }
                        enclodingRequest.setEntity((HttpEntity)this.multipartEntity);
                    }
                    catch (UnsupportedEncodingException e) {
                        LOG.severe("Could not find UTF-8 encoding, something is really wrong", e);
                    }
                } else if (this.multipartEntity != null) {
                    enclodingRequest.setEntity((HttpEntity)this.multipartEntity);
                } else if (this.byteArrayEntity != null) {
                    enclodingRequest.setEntity((HttpEntity)this.byteArrayEntity);
                } else if (this.stringEntity != null) {
                    enclodingRequest.setEntity((HttpEntity)this.stringEntity);
                } else if (this.inputStreamEntity != null) {
                    enclodingRequest.setEntity((HttpEntity)this.inputStreamEntity);
                }
            }
        }
        return this.client.execute(this);
    }

    public int getExpectedStatusCode() {
        return this.expectedStatusCode;
    }

    public void setExpectedStatusCode(int expectedStatusCode) {
        this.expectedStatusCode = expectedStatusCode;
    }

    public OutputStream getOutputStream() {
        return this.outputStream;
    }

    public void setOutputStream(OutputStream outputStream) {
        this.outputStream = outputStream;
    }

    public RequestCallback getRequestCallback() {
        return this.requestCallback;
    }

    public void setRequestCallback(RequestCallback requestCallback) {
        this.requestCallback = requestCallback;
    }

    public ByteArrayOutputStream getCopy() {
        return this.copy;
    }
}

