/*
 * Decompiled with CFR 0.152.
 */
package cz.mallat.uasparser.fileparser;

import cz.mallat.uasparser.fileparser.Entry;
import cz.mallat.uasparser.fileparser.Section;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;

public class PHPFileParser {
    private List<Section> sections;

    public PHPFileParser(InputStream is) throws IOException {
        this.loadFile(new InputStreamReader(is));
    }

    public PHPFileParser(Reader reader) throws IOException {
        this.loadFile(reader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PHPFileParser(File file) throws IOException {
        FileReader reader = new FileReader(file);
        try {
            this.loadFile(reader);
        }
        finally {
            try {
                ((Reader)reader).close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void loadFile(Reader reader) throws IOException {
        this.sections = new ArrayList<Section>();
        BufferedReader bufferedReader = new BufferedReader(reader);
        int unnamedSectionCounter = 0;
        Section currentSection = null;
        Entry currentEntry = null;
        String line = bufferedReader.readLine();
        while (line != null) {
            if (!line.trim().startsWith(";")) {
                if (line.trim().startsWith("[") && line.trim().endsWith("]")) {
                    String rawLine = line.trim();
                    String sectionName = rawLine.substring(1, rawLine.length() - 1);
                    currentSection = new Section(sectionName);
                    this.sections.add(currentSection);
                } else {
                    if (currentSection == null) {
                        currentSection = new Section("unname section" + ++unnamedSectionCounter);
                        this.sections.add(currentSection);
                    }
                    int indexOfEquals = line.indexOf(61);
                    String key = line.substring(0, indexOfEquals);
                    String data = line.substring(indexOfEquals + 1);
                    key = key.replace('[', ' ');
                    key = key.replace(']', ' ');
                    key = key.trim();
                    if ((data = data.trim()).startsWith("\"") && data.endsWith("\"")) {
                        data = data.substring(1, data.length() - 1);
                    }
                    if (currentEntry == null || !currentEntry.getKey().equals(key)) {
                        currentEntry = new Entry(key);
                        currentSection.getEntries().add(currentEntry);
                    }
                    currentEntry.getData().add(data);
                }
            }
            line = bufferedReader.readLine();
        }
    }

    public List<Section> getSections() {
        return this.sections;
    }
}

