/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rds.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeReservedDbInstancesRequest extends RdsRequest implements
        ToCopyableBuilder<DescribeReservedDbInstancesRequest.Builder, DescribeReservedDbInstancesRequest> {
    private static final SdkField<String> RESERVED_DB_INSTANCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ReservedDBInstanceId").getter(getter(DescribeReservedDbInstancesRequest::reservedDBInstanceId))
            .setter(setter(Builder::reservedDBInstanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReservedDBInstanceId").build())
            .build();

    private static final SdkField<String> RESERVED_DB_INSTANCES_OFFERING_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ReservedDBInstancesOfferingId")
            .getter(getter(DescribeReservedDbInstancesRequest::reservedDBInstancesOfferingId))
            .setter(setter(Builder::reservedDBInstancesOfferingId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReservedDBInstancesOfferingId")
                    .build()).build();

    private static final SdkField<String> DB_INSTANCE_CLASS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DBInstanceClass").getter(getter(DescribeReservedDbInstancesRequest::dbInstanceClass))
            .setter(setter(Builder::dbInstanceClass))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBInstanceClass").build()).build();

    private static final SdkField<String> DURATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Duration").getter(getter(DescribeReservedDbInstancesRequest::duration))
            .setter(setter(Builder::duration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Duration").build()).build();

    private static final SdkField<String> PRODUCT_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProductDescription").getter(getter(DescribeReservedDbInstancesRequest::productDescription))
            .setter(setter(Builder::productDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProductDescription").build())
            .build();

    private static final SdkField<String> OFFERING_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OfferingType").getter(getter(DescribeReservedDbInstancesRequest::offeringType))
            .setter(setter(Builder::offeringType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OfferingType").build()).build();

    private static final SdkField<Boolean> MULTI_AZ_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("MultiAZ").getter(getter(DescribeReservedDbInstancesRequest::multiAZ)).setter(setter(Builder::multiAZ))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MultiAZ").build()).build();

    private static final SdkField<String> LEASE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LeaseId").getter(getter(DescribeReservedDbInstancesRequest::leaseId)).setter(setter(Builder::leaseId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LeaseId").build()).build();

    private static final SdkField<List<Filter>> FILTERS_FIELD = SdkField
            .<List<Filter>> builder(MarshallingType.LIST)
            .memberName("Filters")
            .getter(getter(DescribeReservedDbInstancesRequest::filters))
            .setter(setter(Builder::filters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("Filter")
                            .memberFieldInfo(
                                    SdkField.<Filter> builder(MarshallingType.SDK_POJO)
                                            .constructor(Filter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Filter").build()).build()).build()).build();

    private static final SdkField<Integer> MAX_RECORDS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxRecords").getter(getter(DescribeReservedDbInstancesRequest::maxRecords))
            .setter(setter(Builder::maxRecords))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxRecords").build()).build();

    private static final SdkField<String> MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Marker")
            .getter(getter(DescribeReservedDbInstancesRequest::marker)).setter(setter(Builder::marker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESERVED_DB_INSTANCE_ID_FIELD,
            RESERVED_DB_INSTANCES_OFFERING_ID_FIELD, DB_INSTANCE_CLASS_FIELD, DURATION_FIELD, PRODUCT_DESCRIPTION_FIELD,
            OFFERING_TYPE_FIELD, MULTI_AZ_FIELD, LEASE_ID_FIELD, FILTERS_FIELD, MAX_RECORDS_FIELD, MARKER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String reservedDBInstanceId;

    private final String reservedDBInstancesOfferingId;

    private final String dbInstanceClass;

    private final String duration;

    private final String productDescription;

    private final String offeringType;

    private final Boolean multiAZ;

    private final String leaseId;

    private final List<Filter> filters;

    private final Integer maxRecords;

    private final String marker;

    private DescribeReservedDbInstancesRequest(BuilderImpl builder) {
        super(builder);
        this.reservedDBInstanceId = builder.reservedDBInstanceId;
        this.reservedDBInstancesOfferingId = builder.reservedDBInstancesOfferingId;
        this.dbInstanceClass = builder.dbInstanceClass;
        this.duration = builder.duration;
        this.productDescription = builder.productDescription;
        this.offeringType = builder.offeringType;
        this.multiAZ = builder.multiAZ;
        this.leaseId = builder.leaseId;
        this.filters = builder.filters;
        this.maxRecords = builder.maxRecords;
        this.marker = builder.marker;
    }

    /**
     * <p>
     * The reserved DB instance identifier filter value. Specify this parameter to show only the reservation that
     * matches the specified reservation ID.
     * </p>
     * 
     * @return The reserved DB instance identifier filter value. Specify this parameter to show only the reservation
     *         that matches the specified reservation ID.
     */
    public final String reservedDBInstanceId() {
        return reservedDBInstanceId;
    }

    /**
     * <p>
     * The offering identifier filter value. Specify this parameter to show only purchased reservations matching the
     * specified offering identifier.
     * </p>
     * 
     * @return The offering identifier filter value. Specify this parameter to show only purchased reservations matching
     *         the specified offering identifier.
     */
    public final String reservedDBInstancesOfferingId() {
        return reservedDBInstancesOfferingId;
    }

    /**
     * <p>
     * The DB instance class filter value. Specify this parameter to show only those reservations matching the specified
     * DB instances class.
     * </p>
     * 
     * @return The DB instance class filter value. Specify this parameter to show only those reservations matching the
     *         specified DB instances class.
     */
    public final String dbInstanceClass() {
        return dbInstanceClass;
    }

    /**
     * <p>
     * The duration filter value, specified in years or seconds. Specify this parameter to show only reservations for
     * this duration.
     * </p>
     * <p>
     * Valid Values: <code>1 | 3 | 31536000 | 94608000</code>
     * </p>
     * 
     * @return The duration filter value, specified in years or seconds. Specify this parameter to show only
     *         reservations for this duration.</p>
     *         <p>
     *         Valid Values: <code>1 | 3 | 31536000 | 94608000</code>
     */
    public final String duration() {
        return duration;
    }

    /**
     * <p>
     * The product description filter value. Specify this parameter to show only those reservations matching the
     * specified product description.
     * </p>
     * 
     * @return The product description filter value. Specify this parameter to show only those reservations matching the
     *         specified product description.
     */
    public final String productDescription() {
        return productDescription;
    }

    /**
     * <p>
     * The offering type filter value. Specify this parameter to show only the available offerings matching the
     * specified offering type.
     * </p>
     * <p>
     * Valid Values: <code>"Partial Upfront" | "All Upfront" | "No Upfront" </code>
     * </p>
     * 
     * @return The offering type filter value. Specify this parameter to show only the available offerings matching the
     *         specified offering type.</p>
     *         <p>
     *         Valid Values: <code>"Partial Upfront" | "All Upfront" | "No Upfront" </code>
     */
    public final String offeringType() {
        return offeringType;
    }

    /**
     * <p>
     * Specifies whether to show only those reservations that support Multi-AZ.
     * </p>
     * 
     * @return Specifies whether to show only those reservations that support Multi-AZ.
     */
    public final Boolean multiAZ() {
        return multiAZ;
    }

    /**
     * <p>
     * The lease identifier filter value. Specify this parameter to show only the reservation that matches the specified
     * lease ID.
     * </p>
     * <note>
     * <p>
     * Amazon Web Services Support might request the lease ID for an issue related to a reserved DB instance.
     * </p>
     * </note>
     * 
     * @return The lease identifier filter value. Specify this parameter to show only the reservation that matches the
     *         specified lease ID.</p> <note>
     *         <p>
     *         Amazon Web Services Support might request the lease ID for an issue related to a reserved DB instance.
     *         </p>
     */
    public final String leaseId() {
        return leaseId;
    }

    /**
     * For responses, this returns true if the service returned a value for the Filters property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasFilters() {
        return filters != null && !(filters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * This parameter isn't currently supported.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFilters} method.
     * </p>
     * 
     * @return This parameter isn't currently supported.
     */
    public final List<Filter> filters() {
        return filters;
    }

    /**
     * <p>
     * The maximum number of records to include in the response. If more than the <code>MaxRecords</code> value is
     * available, a pagination token called a marker is included in the response so you can retrieve the remaining
     * results.
     * </p>
     * <p>
     * Default: 100
     * </p>
     * <p>
     * Constraints: Minimum 20, maximum 100.
     * </p>
     * 
     * @return The maximum number of records to include in the response. If more than the <code>MaxRecords</code> value
     *         is available, a pagination token called a marker is included in the response so you can retrieve the
     *         remaining results.</p>
     *         <p>
     *         Default: 100
     *         </p>
     *         <p>
     *         Constraints: Minimum 20, maximum 100.
     */
    public final Integer maxRecords() {
        return maxRecords;
    }

    /**
     * <p>
     * An optional pagination token provided by a previous request. If this parameter is specified, the response
     * includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.
     * </p>
     * 
     * @return An optional pagination token provided by a previous request. If this parameter is specified, the response
     *         includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.
     */
    public final String marker() {
        return marker;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(reservedDBInstanceId());
        hashCode = 31 * hashCode + Objects.hashCode(reservedDBInstancesOfferingId());
        hashCode = 31 * hashCode + Objects.hashCode(dbInstanceClass());
        hashCode = 31 * hashCode + Objects.hashCode(duration());
        hashCode = 31 * hashCode + Objects.hashCode(productDescription());
        hashCode = 31 * hashCode + Objects.hashCode(offeringType());
        hashCode = 31 * hashCode + Objects.hashCode(multiAZ());
        hashCode = 31 * hashCode + Objects.hashCode(leaseId());
        hashCode = 31 * hashCode + Objects.hashCode(hasFilters() ? filters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(maxRecords());
        hashCode = 31 * hashCode + Objects.hashCode(marker());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeReservedDbInstancesRequest)) {
            return false;
        }
        DescribeReservedDbInstancesRequest other = (DescribeReservedDbInstancesRequest) obj;
        return Objects.equals(reservedDBInstanceId(), other.reservedDBInstanceId())
                && Objects.equals(reservedDBInstancesOfferingId(), other.reservedDBInstancesOfferingId())
                && Objects.equals(dbInstanceClass(), other.dbInstanceClass()) && Objects.equals(duration(), other.duration())
                && Objects.equals(productDescription(), other.productDescription())
                && Objects.equals(offeringType(), other.offeringType()) && Objects.equals(multiAZ(), other.multiAZ())
                && Objects.equals(leaseId(), other.leaseId()) && hasFilters() == other.hasFilters()
                && Objects.equals(filters(), other.filters()) && Objects.equals(maxRecords(), other.maxRecords())
                && Objects.equals(marker(), other.marker());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeReservedDbInstancesRequest").add("ReservedDBInstanceId", reservedDBInstanceId())
                .add("ReservedDBInstancesOfferingId", reservedDBInstancesOfferingId()).add("DBInstanceClass", dbInstanceClass())
                .add("Duration", duration()).add("ProductDescription", productDescription()).add("OfferingType", offeringType())
                .add("MultiAZ", multiAZ()).add("LeaseId", leaseId()).add("Filters", hasFilters() ? filters() : null)
                .add("MaxRecords", maxRecords()).add("Marker", marker()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ReservedDBInstanceId":
            return Optional.ofNullable(clazz.cast(reservedDBInstanceId()));
        case "ReservedDBInstancesOfferingId":
            return Optional.ofNullable(clazz.cast(reservedDBInstancesOfferingId()));
        case "DBInstanceClass":
            return Optional.ofNullable(clazz.cast(dbInstanceClass()));
        case "Duration":
            return Optional.ofNullable(clazz.cast(duration()));
        case "ProductDescription":
            return Optional.ofNullable(clazz.cast(productDescription()));
        case "OfferingType":
            return Optional.ofNullable(clazz.cast(offeringType()));
        case "MultiAZ":
            return Optional.ofNullable(clazz.cast(multiAZ()));
        case "LeaseId":
            return Optional.ofNullable(clazz.cast(leaseId()));
        case "Filters":
            return Optional.ofNullable(clazz.cast(filters()));
        case "MaxRecords":
            return Optional.ofNullable(clazz.cast(maxRecords()));
        case "Marker":
            return Optional.ofNullable(clazz.cast(marker()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ReservedDBInstanceId", RESERVED_DB_INSTANCE_ID_FIELD);
        map.put("ReservedDBInstancesOfferingId", RESERVED_DB_INSTANCES_OFFERING_ID_FIELD);
        map.put("DBInstanceClass", DB_INSTANCE_CLASS_FIELD);
        map.put("Duration", DURATION_FIELD);
        map.put("ProductDescription", PRODUCT_DESCRIPTION_FIELD);
        map.put("OfferingType", OFFERING_TYPE_FIELD);
        map.put("MultiAZ", MULTI_AZ_FIELD);
        map.put("LeaseId", LEASE_ID_FIELD);
        map.put("Filters", FILTERS_FIELD);
        map.put("MaxRecords", MAX_RECORDS_FIELD);
        map.put("Marker", MARKER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeReservedDbInstancesRequest, T> g) {
        return obj -> g.apply((DescribeReservedDbInstancesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends RdsRequest.Builder, SdkPojo, CopyableBuilder<Builder, DescribeReservedDbInstancesRequest> {
        /**
         * <p>
         * The reserved DB instance identifier filter value. Specify this parameter to show only the reservation that
         * matches the specified reservation ID.
         * </p>
         * 
         * @param reservedDBInstanceId
         *        The reserved DB instance identifier filter value. Specify this parameter to show only the reservation
         *        that matches the specified reservation ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reservedDBInstanceId(String reservedDBInstanceId);

        /**
         * <p>
         * The offering identifier filter value. Specify this parameter to show only purchased reservations matching the
         * specified offering identifier.
         * </p>
         * 
         * @param reservedDBInstancesOfferingId
         *        The offering identifier filter value. Specify this parameter to show only purchased reservations
         *        matching the specified offering identifier.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reservedDBInstancesOfferingId(String reservedDBInstancesOfferingId);

        /**
         * <p>
         * The DB instance class filter value. Specify this parameter to show only those reservations matching the
         * specified DB instances class.
         * </p>
         * 
         * @param dbInstanceClass
         *        The DB instance class filter value. Specify this parameter to show only those reservations matching
         *        the specified DB instances class.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbInstanceClass(String dbInstanceClass);

        /**
         * <p>
         * The duration filter value, specified in years or seconds. Specify this parameter to show only reservations
         * for this duration.
         * </p>
         * <p>
         * Valid Values: <code>1 | 3 | 31536000 | 94608000</code>
         * </p>
         * 
         * @param duration
         *        The duration filter value, specified in years or seconds. Specify this parameter to show only
         *        reservations for this duration.</p>
         *        <p>
         *        Valid Values: <code>1 | 3 | 31536000 | 94608000</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder duration(String duration);

        /**
         * <p>
         * The product description filter value. Specify this parameter to show only those reservations matching the
         * specified product description.
         * </p>
         * 
         * @param productDescription
         *        The product description filter value. Specify this parameter to show only those reservations matching
         *        the specified product description.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder productDescription(String productDescription);

        /**
         * <p>
         * The offering type filter value. Specify this parameter to show only the available offerings matching the
         * specified offering type.
         * </p>
         * <p>
         * Valid Values: <code>"Partial Upfront" | "All Upfront" | "No Upfront" </code>
         * </p>
         * 
         * @param offeringType
         *        The offering type filter value. Specify this parameter to show only the available offerings matching
         *        the specified offering type.</p>
         *        <p>
         *        Valid Values: <code>"Partial Upfront" | "All Upfront" | "No Upfront" </code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder offeringType(String offeringType);

        /**
         * <p>
         * Specifies whether to show only those reservations that support Multi-AZ.
         * </p>
         * 
         * @param multiAZ
         *        Specifies whether to show only those reservations that support Multi-AZ.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder multiAZ(Boolean multiAZ);

        /**
         * <p>
         * The lease identifier filter value. Specify this parameter to show only the reservation that matches the
         * specified lease ID.
         * </p>
         * <note>
         * <p>
         * Amazon Web Services Support might request the lease ID for an issue related to a reserved DB instance.
         * </p>
         * </note>
         * 
         * @param leaseId
         *        The lease identifier filter value. Specify this parameter to show only the reservation that matches
         *        the specified lease ID.</p> <note>
         *        <p>
         *        Amazon Web Services Support might request the lease ID for an issue related to a reserved DB instance.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder leaseId(String leaseId);

        /**
         * <p>
         * This parameter isn't currently supported.
         * </p>
         * 
         * @param filters
         *        This parameter isn't currently supported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Collection<Filter> filters);

        /**
         * <p>
         * This parameter isn't currently supported.
         * </p>
         * 
         * @param filters
         *        This parameter isn't currently supported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Filter... filters);

        /**
         * <p>
         * This parameter isn't currently supported.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.rds.model.Filter.Builder} avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.rds.model.Filter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link software.amazon.awssdk.services.rds.model.Filter.Builder#build()}
         * is called immediately and its result is passed to {@link #filters(List<Filter>)}.
         * 
         * @param filters
         *        a consumer that will call methods on {@link software.amazon.awssdk.services.rds.model.Filter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filters(java.util.Collection<Filter>)
         */
        Builder filters(Consumer<Filter.Builder>... filters);

        /**
         * <p>
         * The maximum number of records to include in the response. If more than the <code>MaxRecords</code> value is
         * available, a pagination token called a marker is included in the response so you can retrieve the remaining
         * results.
         * </p>
         * <p>
         * Default: 100
         * </p>
         * <p>
         * Constraints: Minimum 20, maximum 100.
         * </p>
         * 
         * @param maxRecords
         *        The maximum number of records to include in the response. If more than the <code>MaxRecords</code>
         *        value is available, a pagination token called a marker is included in the response so you can retrieve
         *        the remaining results.</p>
         *        <p>
         *        Default: 100
         *        </p>
         *        <p>
         *        Constraints: Minimum 20, maximum 100.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxRecords(Integer maxRecords);

        /**
         * <p>
         * An optional pagination token provided by a previous request. If this parameter is specified, the response
         * includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.
         * </p>
         * 
         * @param marker
         *        An optional pagination token provided by a previous request. If this parameter is specified, the
         *        response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>
         *        .
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marker(String marker);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends RdsRequest.BuilderImpl implements Builder {
        private String reservedDBInstanceId;

        private String reservedDBInstancesOfferingId;

        private String dbInstanceClass;

        private String duration;

        private String productDescription;

        private String offeringType;

        private Boolean multiAZ;

        private String leaseId;

        private List<Filter> filters = DefaultSdkAutoConstructList.getInstance();

        private Integer maxRecords;

        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeReservedDbInstancesRequest model) {
            super(model);
            reservedDBInstanceId(model.reservedDBInstanceId);
            reservedDBInstancesOfferingId(model.reservedDBInstancesOfferingId);
            dbInstanceClass(model.dbInstanceClass);
            duration(model.duration);
            productDescription(model.productDescription);
            offeringType(model.offeringType);
            multiAZ(model.multiAZ);
            leaseId(model.leaseId);
            filters(model.filters);
            maxRecords(model.maxRecords);
            marker(model.marker);
        }

        public final String getReservedDBInstanceId() {
            return reservedDBInstanceId;
        }

        public final void setReservedDBInstanceId(String reservedDBInstanceId) {
            this.reservedDBInstanceId = reservedDBInstanceId;
        }

        @Override
        public final Builder reservedDBInstanceId(String reservedDBInstanceId) {
            this.reservedDBInstanceId = reservedDBInstanceId;
            return this;
        }

        public final String getReservedDBInstancesOfferingId() {
            return reservedDBInstancesOfferingId;
        }

        public final void setReservedDBInstancesOfferingId(String reservedDBInstancesOfferingId) {
            this.reservedDBInstancesOfferingId = reservedDBInstancesOfferingId;
        }

        @Override
        public final Builder reservedDBInstancesOfferingId(String reservedDBInstancesOfferingId) {
            this.reservedDBInstancesOfferingId = reservedDBInstancesOfferingId;
            return this;
        }

        public final String getDbInstanceClass() {
            return dbInstanceClass;
        }

        public final void setDbInstanceClass(String dbInstanceClass) {
            this.dbInstanceClass = dbInstanceClass;
        }

        @Override
        public final Builder dbInstanceClass(String dbInstanceClass) {
            this.dbInstanceClass = dbInstanceClass;
            return this;
        }

        public final String getDuration() {
            return duration;
        }

        public final void setDuration(String duration) {
            this.duration = duration;
        }

        @Override
        public final Builder duration(String duration) {
            this.duration = duration;
            return this;
        }

        public final String getProductDescription() {
            return productDescription;
        }

        public final void setProductDescription(String productDescription) {
            this.productDescription = productDescription;
        }

        @Override
        public final Builder productDescription(String productDescription) {
            this.productDescription = productDescription;
            return this;
        }

        public final String getOfferingType() {
            return offeringType;
        }

        public final void setOfferingType(String offeringType) {
            this.offeringType = offeringType;
        }

        @Override
        public final Builder offeringType(String offeringType) {
            this.offeringType = offeringType;
            return this;
        }

        public final Boolean getMultiAZ() {
            return multiAZ;
        }

        public final void setMultiAZ(Boolean multiAZ) {
            this.multiAZ = multiAZ;
        }

        @Override
        public final Builder multiAZ(Boolean multiAZ) {
            this.multiAZ = multiAZ;
            return this;
        }

        public final String getLeaseId() {
            return leaseId;
        }

        public final void setLeaseId(String leaseId) {
            this.leaseId = leaseId;
        }

        @Override
        public final Builder leaseId(String leaseId) {
            this.leaseId = leaseId;
            return this;
        }

        public final List<Filter.Builder> getFilters() {
            List<Filter.Builder> result = FilterListCopier.copyToBuilder(this.filters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFilters(Collection<Filter.BuilderImpl> filters) {
            this.filters = FilterListCopier.copyFromBuilder(filters);
        }

        @Override
        public final Builder filters(Collection<Filter> filters) {
            this.filters = FilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Filter... filters) {
            filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Consumer<Filter.Builder>... filters) {
            filters(Stream.of(filters).map(c -> Filter.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Integer getMaxRecords() {
            return maxRecords;
        }

        public final void setMaxRecords(Integer maxRecords) {
            this.maxRecords = maxRecords;
        }

        @Override
        public final Builder maxRecords(Integer maxRecords) {
            this.maxRecords = maxRecords;
            return this;
        }

        public final String getMarker() {
            return marker;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeReservedDbInstancesRequest build() {
            return new DescribeReservedDbInstancesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
