/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.qatools.embed.postgresql.util;

import java.io.IOException;
import java.net.ServerSocket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SocketUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(SocketUtil.class);

    private SocketUtil() {
    }

    public static int findFreePort() {
        ServerSocket socket = null;
        try {
            socket = new ServerSocket(0);
            socket.setReuseAddress(true);
            int port = socket.getLocalPort();
            SocketUtil.closeQuietly(socket);
            int n = port;
            return n;
        }
        catch (IOException e) {
            LOGGER.trace("Failed to open socket", (Throwable)e);
        }
        finally {
            if (socket != null) {
                SocketUtil.closeQuietly(socket);
            }
        }
        throw new IllegalStateException("Could not find a free TCP/IP port to start embedded Jetty HTTP Server on");
    }

    private static void closeQuietly(ServerSocket socket) {
        try {
            socket.close();
        }
        catch (IOException e) {
            LOGGER.trace("Failed to close socket", (Throwable)e);
        }
    }
}

