/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.model.transformer;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.isdc.wro.model.WroModel;
import ro.isdc.wro.model.group.Group;
import ro.isdc.wro.model.group.Inject;
import ro.isdc.wro.model.resource.Resource;
import ro.isdc.wro.model.resource.locator.ClasspathUriLocator;
import ro.isdc.wro.model.resource.locator.UriLocator;
import ro.isdc.wro.model.resource.locator.factory.UriLocatorFactory;
import ro.isdc.wro.model.resource.locator.wildcard.WildcardExpanderHandlerAware;
import ro.isdc.wro.model.resource.locator.wildcard.WildcardStreamLocator;
import ro.isdc.wro.model.resource.locator.wildcard.WildcardUriLocatorSupport;
import ro.isdc.wro.util.Function;
import ro.isdc.wro.util.Transformer;

public class WildcardExpanderModelTransformer
implements Transformer<WroModel> {
    private static final Logger LOG = LoggerFactory.getLogger(WildcardExpanderModelTransformer.class);
    @Inject
    private UriLocatorFactory locatorFactory;

    @Override
    public synchronized WroModel transform(WroModel model) {
        for (Group group : model.getGroups()) {
            List<Resource> resources = group.getResources();
            for (Resource resource : resources) {
                this.processResource(group, resource);
            }
        }
        LOG.debug("Transformed model: {}", (Object)model);
        return model;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processResource(Group group, Resource resource) {
        WildcardStreamLocator wildcardStreamLocator;
        UriLocator uriLocator = this.locatorFactory.getInstance(resource.getUri());
        if (uriLocator instanceof WildcardUriLocatorSupport && (wildcardStreamLocator = ((WildcardUriLocatorSupport)uriLocator).getWildcardStreamLocator()).hasWildcard(resource.getUri()) && wildcardStreamLocator instanceof WildcardExpanderHandlerAware) {
            WildcardExpanderHandlerAware expandedHandler = (WildcardExpanderHandlerAware)((Object)wildcardStreamLocator);
            LOG.debug("Expanding resource: {}", (Object)resource.getUri());
            String baseNameFolder = this.computeBaseNameFolder(resource, uriLocator, expandedHandler);
            LOG.debug("baseNameFolder: {}", (Object)baseNameFolder);
            expandedHandler.setWildcardExpanderHandler(this.createExpanderHandler(group, resource, baseNameFolder));
            try {
                uriLocator.locate(resource.getUri());
            }
            catch (IOException e) {
                LOG.debug("[FAIL] problem while trying to expand wildcard for the following resource uri: {}", (Object)resource.getUri());
            }
            finally {
                expandedHandler.setWildcardExpanderHandler(null);
            }
        }
    }

    private String computeBaseNameFolder(Resource resource, UriLocator uriLocator, WildcardExpanderHandlerAware expandedHandler) {
        LOG.debug("computeBaseNameFolder for resource {}", (Object)resource);
        String resourcePath = FilenameUtils.getFullPath((String)resource.getUri()) + "**";
        LOG.debug("resourcePath: {}", (Object)resourcePath);
        ThreadLocal<String> baseNameFolderHolder = new ThreadLocal<String>();
        expandedHandler.setWildcardExpanderHandler(this.createBaseNameComputerFunction(baseNameFolderHolder));
        try {
            uriLocator.locate(resourcePath);
        }
        catch (Exception e) {
            LOG.debug("[FAIL] Exception caught during wildcard expanding for resource: {}\n with exception message {}", (Object)resourcePath, (Object)e.getMessage());
        }
        if (baseNameFolderHolder.get() == null) {
            LOG.debug("[FAIL] Cannot compute baseName folder for resource: {}", (Object)resource);
        }
        return baseNameFolderHolder.get();
    }

    private Function<Collection<File>, Void> createBaseNameComputerFunction(final ThreadLocal<String> baseNameFolderHolder) {
        return new Function<Collection<File>, Void>(){

            @Override
            public Void apply(Collection<File> input) throws Exception {
                LOG.debug("\texpanded Files: {}", input);
                Iterator<File> iterator = input.iterator();
                if (iterator.hasNext()) {
                    File file = iterator.next();
                    LOG.debug("\tsetting baseNameFolder: {}", (Object)file.getParent());
                    baseNameFolderHolder.set(file.getParent());
                }
                throw new NoMoreAttemptsIOException("BaseNameFolder computed successfully, skip further wildcard processing..");
            }
        };
    }

    public Function<Collection<File>, Void> createExpanderHandler(final Group group, final Resource resource, final String baseNameFolder) {
        LOG.debug("createExpanderHandler using baseNameFolder: {}\n for resource {}", (Object)baseNameFolder, (Object)resource);
        return new Function<Collection<File>, Void>(){

            @Override
            public Void apply(Collection<File> files) {
                if (baseNameFolder == null) {
                    LOG.warn("The resource {} is probably invalid, removing it from the group.", (Object)resource);
                    group.replace(resource, new ArrayList<Resource>());
                } else {
                    ArrayList<Resource> expandedResources = new ArrayList<Resource>();
                    LOG.debug("baseNameFolder: {}", (Object)baseNameFolder);
                    for (File file : files) {
                        String resourcePath = this.getFullPathNoEndSeparator(resource);
                        String filePath = file.getPath();
                        LOG.debug("\tResource path: {}", (Object)resourcePath);
                        LOG.debug("\tFile path: {}", (Object)filePath);
                        String resourcePathWithoutProtocol = resourcePath.startsWith(ClasspathUriLocator.PREFIX) ? resourcePath.replaceFirst(ClasspathUriLocator.PREFIX, "") : resourcePath;
                        LOG.debug("\tResource path without protocol: {}", (Object)resourcePathWithoutProtocol);
                        String baseNameTrimmedFromResourcePath = StringUtils.isEmpty((CharSequence)resourcePathWithoutProtocol) ? baseNameFolder : baseNameFolder.replaceFirst(".*" + resourcePathWithoutProtocol, "");
                        LOG.debug("\tBase folder name trimmed from resource path: {}", (Object)baseNameTrimmedFromResourcePath);
                        String filePathWithoutStart = StringUtils.removeStart((String)filePath, (String)baseNameTrimmedFromResourcePath).replace('\\', '/');
                        String computedResourceUri = StringUtils.isEmpty((CharSequence)resourcePathWithoutProtocol) ? resourcePath + filePathWithoutStart : resourcePath + filePathWithoutStart.replaceFirst(".*" + resourcePathWithoutProtocol, "");
                        LOG.debug("\tComputed resource URI: {}", (Object)computedResourceUri);
                        Resource expandedResource = Resource.create(computedResourceUri, resource.getType());
                        LOG.debug("\texpanded resource: {}", (Object)expandedResource);
                        expandedResources.add(expandedResource);
                    }
                    LOG.debug("\treplace resource {}", (Object)resource);
                    group.replace(resource, expandedResources);
                }
                return null;
            }

            private String getFullPathNoEndSeparator(Resource resource1) {
                String result = FilenameUtils.getFullPathNoEndSeparator((String)resource1.getUri());
                if (result != null && 1 == result.length() && 0 == FilenameUtils.indexOfLastSeparator((String)result)) {
                    return "";
                }
                return result;
            }
        };
    }

    public static class NoMoreAttemptsIOException
    extends IOException {
        public NoMoreAttemptsIOException(String message) {
            super(message);
        }
    }
}

