/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.manager.factory.standalone;

import jakarta.servlet.http.HttpServletRequest;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.isdc.wro.config.Context;
import ro.isdc.wro.manager.factory.standalone.StandaloneContext;
import ro.isdc.wro.manager.factory.standalone.StandaloneContextAware;
import ro.isdc.wro.manager.factory.standalone.StandaloneWroManagerFactory;
import ro.isdc.wro.model.factory.WroModelFactory;
import ro.isdc.wro.model.factory.XmlModelFactory;
import ro.isdc.wro.model.group.GroupExtractor;
import ro.isdc.wro.model.group.processor.GroupExtractorDecorator;
import ro.isdc.wro.model.resource.locator.ServletContextUriLocator;
import ro.isdc.wro.model.resource.locator.StandaloneServletContextUriLocator;
import ro.isdc.wro.model.resource.processor.factory.DefaultProcessorsFactory;
import ro.isdc.wro.model.resource.processor.factory.ProcessorsFactory;

public class DefaultStandaloneContextAwareManagerFactory
extends StandaloneWroManagerFactory
implements StandaloneContextAware {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultStandaloneContextAwareManagerFactory.class);
    private StandaloneContext standaloneContext;

    @Override
    public void initialize(StandaloneContext standaloneContext) {
        Validate.notNull((Object)standaloneContext);
        this.standaloneContext = standaloneContext;
        if (standaloneContext.getIgnoreMissingResourcesAsString() != null) {
            Context.get().getConfig().setIgnoreMissingResources(Boolean.parseBoolean(standaloneContext.getIgnoreMissingResourcesAsString()));
        }
        LOG.debug("initialize: {}", (Object)standaloneContext);
        LOG.debug("config: {}", (Object)Context.get().getConfig());
    }

    @Override
    protected GroupExtractor newGroupExtractor() {
        return new GroupExtractorDecorator(super.newGroupExtractor()){

            @Override
            public boolean isMinimized(HttpServletRequest request) {
                return DefaultStandaloneContextAwareManagerFactory.this.standaloneContext.isMinimize();
            }
        };
    }

    @Override
    protected WroModelFactory newModelFactory() {
        return new XmlModelFactory(){

            @Override
            protected InputStream getModelResourceAsStream() throws IOException {
                return new FileInputStream(DefaultStandaloneContextAwareManagerFactory.this.standaloneContext.getWroFile());
            }
        };
    }

    @Override
    protected ProcessorsFactory newProcessorsFactory() {
        return new DefaultProcessorsFactory();
    }

    @Override
    protected ServletContextUriLocator newServletContextUriLocator() {
        StandaloneServletContextUriLocator locator = new StandaloneServletContextUriLocator();
        locator.initialize(this.standaloneContext);
        return locator;
    }

    protected final StandaloneContext getStandaloneContext() {
        return this.standaloneContext;
    }
}

