/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.http.handler;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.UUID;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.isdc.wro.WroRuntimeException;
import ro.isdc.wro.cache.CacheKey;
import ro.isdc.wro.http.handler.RequestHandlerSupport;
import ro.isdc.wro.model.group.Inject;
import ro.isdc.wro.model.resource.ResourceType;
import ro.isdc.wro.model.resource.support.change.ResourceWatcher;

public class ResourceWatcherRequestHandler
extends RequestHandlerSupport {
    private static final Logger LOG = LoggerFactory.getLogger(ResourceWatcherRequestHandler.class);
    static final String PARAM_GROUP_NAME = "group";
    static final String PARAM_RESOURCE_TYPE = "resourceType";
    static final String PARAM_AUTH_KEY = "auth";
    static final String PATH_HANDLER = "resourceWatcher";
    public static final String ALIAS = "resourceWatcher";
    @Inject
    private ResourceWatcher resourceWatcher;
    private static String authorizationKey;

    public ResourceWatcherRequestHandler() {
        this.updateAuthorizationKey();
    }

    @Override
    public void handle(HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.resourceWatcher.check(this.retrieveCacheKey(request));
        this.updateAuthorizationKey();
    }

    private CacheKey retrieveCacheKey(HttpServletRequest request) {
        CacheKey cacheKey = null;
        String resourceTypeAsString = request.getParameter(PARAM_RESOURCE_TYPE);
        String groupName = request.getParameter(PARAM_GROUP_NAME);
        try {
            ResourceType resourceType = ResourceType.get(resourceTypeAsString);
            Validate.isTrue((groupName != null ? 1 : 0) != 0);
            if (groupName != null) {
                LOG.debug("groupName={}, resourceType={}", (Object)groupName, (Object)resourceType);
                cacheKey = new CacheKey(groupName, resourceType);
            }
        }
        catch (IllegalArgumentException e) {
            LOG.debug("groupName={}, resourceType={}", (Object)groupName, (Object)resourceTypeAsString);
            throw WroRuntimeException.wrap(e, "Cannot retrieve cacheKey from the request");
        }
        return cacheKey;
    }

    @Override
    public boolean accept(HttpServletRequest request) {
        boolean isHandlerRequest = this.isHandlerRequest(request);
        return isHandlerRequest && this.isAuthorized(request);
    }

    private boolean isAuthorized(HttpServletRequest request) {
        String actualKey = request.getParameter(PARAM_AUTH_KEY);
        boolean isAuthorized = authorizationKey.equals(actualKey);
        if (!isAuthorized) {
            LOG.debug("Unauthorized request. actualKey={}, expected={}", (Object)actualKey, (Object)authorizationKey);
        }
        return isAuthorized;
    }

    private boolean isHandlerRequest(HttpServletRequest request) {
        String apiHandlerValue = request.getParameter("wroAPI");
        return "resourceWatcher".equals(apiHandlerValue) && this.retrieveCacheKey(request) != null;
    }

    private void updateAuthorizationKey() {
        authorizationKey = this.generateRandomKey();
    }

    String generateRandomKey() {
        return UUID.randomUUID().toString();
    }

    public static String createHandlerRequestPath(CacheKey cacheKey, HttpServletRequest request) {
        String handlerQueryPath = ResourceWatcherRequestHandler.getRequestHandlerPath(cacheKey.getGroupName(), cacheKey.getType());
        return request.getServletPath() + handlerQueryPath;
    }

    private static String getRequestHandlerPath() {
        return String.format("?%s=%s", "wroAPI", "resourceWatcher");
    }

    private static String getRequestHandlerPath(String groupName, ResourceType resourceType) {
        return String.format("%s&%s=%s&%s=%s&%s=%s", ResourceWatcherRequestHandler.getRequestHandlerPath(), PARAM_GROUP_NAME, groupName, PARAM_RESOURCE_TYPE, resourceType.name(), PARAM_AUTH_KEY, authorizationKey);
    }
}

