/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.http;

import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletContextEvent;
import jakarta.servlet.ServletContextListener;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.isdc.wro.config.factory.ServletContextPropertyWroConfigurationFactory;
import ro.isdc.wro.config.jmx.WroConfiguration;
import ro.isdc.wro.http.support.ServletContextAttributeHelper;
import ro.isdc.wro.manager.factory.DefaultWroManagerFactory;
import ro.isdc.wro.manager.factory.WroManagerFactory;

public class WroServletContextListener
implements ServletContextListener {
    private static final Logger LOG = LoggerFactory.getLogger(WroServletContextListener.class);
    private WroConfiguration configuration;
    private WroManagerFactory managerFactory;
    private ServletContext servletContext;
    private ServletContextAttributeHelper attributeHelper;

    public final void contextInitialized(ServletContextEvent event) {
        this.servletContext = event.getServletContext();
        this.attributeHelper = new ServletContextAttributeHelper(this.servletContext, this.getListenerName());
        this.initListener(event.getServletContext());
    }

    private void initListener(ServletContext servletContext) {
        if (this.attributeHelper.getWroConfiguration() != null || this.attributeHelper.getManagerFactory() != null) {
            String message = "Cannot initialize context because there is already a listener present - withName: " + this.getListenerName() + ". Check whether you have multiple listener* (of type WroServletContextListener) definitions in your web.xml!";
            LOG.error(message);
            throw new IllegalStateException(message);
        }
        this.configuration = this.createConfiguration();
        this.managerFactory = this.createManagerFactory();
        LOG.debug("Loaded managerFactory: {}", this.managerFactory.getClass());
        this.attributeHelper.setWroConfiguration(this.configuration);
        this.attributeHelper.setManagerFactory(this.managerFactory);
    }

    private WroConfiguration createConfiguration() {
        return this.configuration != null ? this.configuration : this.newConfiguration();
    }

    protected WroConfiguration newConfiguration() {
        return new ServletContextPropertyWroConfigurationFactory(this.servletContext).create();
    }

    private WroManagerFactory createManagerFactory() {
        return this.managerFactory != null ? this.managerFactory : this.newManagerFactory();
    }

    protected WroManagerFactory newManagerFactory() {
        return DefaultWroManagerFactory.create(this.configuration);
    }

    public final void contextDestroyed(ServletContextEvent servletContextEvent) {
        this.attributeHelper.clear();
    }

    public final void setManagerFactory(WroManagerFactory managerFactory) {
        Validate.notNull((Object)managerFactory);
        this.managerFactory = managerFactory;
    }

    protected String getListenerName() {
        return "default";
    }

    public final void setConfiguration(WroConfiguration configuration) {
        Validate.notNull((Object)configuration);
        this.configuration = configuration;
    }

    final WroConfiguration getConfiguration() {
        return this.configuration;
    }

    final WroManagerFactory getManagerFactory() {
        return this.managerFactory;
    }
}

