/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.http;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import ro.isdc.wro.config.Context;
import ro.isdc.wro.config.jmx.WroConfiguration;
import ro.isdc.wro.http.support.ServletContextAttributeHelper;

public class WroContextFilter
implements Filter {
    private FilterConfig filterConfig;

    public void init(FilterConfig filterConfig) throws ServletException {
        this.filterConfig = filterConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)res;
        String originalCorrelationId = Context.isContextSet() ? Context.getCorrelationId() : null;
        Context.set(Context.webContext(request, response, this.filterConfig), this.getWroConfiguration());
        String correlationId = Context.getCorrelationId();
        try {
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
        finally {
            Context.setCorrelationId(correlationId);
            Context.unset();
            if (originalCorrelationId != null) {
                Context.setCorrelationId(originalCorrelationId);
            }
        }
    }

    private WroConfiguration getWroConfiguration() {
        WroConfiguration configAttribute = this.getServletContextAttributeHelper().getWroConfiguration();
        return configAttribute != null ? configAttribute : new WroConfiguration();
    }

    ServletContextAttributeHelper getServletContextAttributeHelper() {
        return ServletContextAttributeHelper.create(this.filterConfig);
    }

    public void destroy() {
        Context.destroy();
    }
}

