/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.config.factory;

import jakarta.servlet.ServletContext;
import java.io.InputStream;
import java.util.Properties;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.isdc.wro.config.factory.PropertyWroConfigurationFactory;
import ro.isdc.wro.config.jmx.WroConfiguration;
import ro.isdc.wro.util.ObjectFactory;

public class ServletContextPropertyWroConfigurationFactory
implements ObjectFactory<WroConfiguration> {
    private static final Logger LOG = LoggerFactory.getLogger(ServletContextPropertyWroConfigurationFactory.class);
    private static final String DEFAULT_PROPERTIES_FILE_NAME = "/WEB-INF/wro.properties";
    private ServletContext servletContext;

    public ServletContextPropertyWroConfigurationFactory(ServletContext servletContext) {
        Validate.notNull((Object)servletContext);
        this.servletContext = servletContext;
    }

    protected String getConfigPath() {
        return DEFAULT_PROPERTIES_FILE_NAME;
    }

    @Override
    public final WroConfiguration create() {
        return new PropertyWroConfigurationFactory(this.createProperties()).create();
    }

    public Properties createProperties() {
        Properties props = new Properties();
        try (InputStream propertyStream = this.servletContext.getResourceAsStream(this.getConfigPath());){
            LOG.debug("loading config resource from: {}", (Object)this.getConfigPath());
            Validate.notNull((Object)propertyStream);
            props.load(propertyStream);
        }
        catch (Exception e) {
            LOG.warn("[WARN] Cannot read properties file stream from default location: {}. Using default configuration.", (Object)this.getConfigPath());
        }
        return props;
    }
}

