/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.config.factory;

import jakarta.servlet.FilterConfig;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.isdc.wro.config.factory.PropertyWroConfigurationFactory;
import ro.isdc.wro.config.jmx.WroConfiguration;
import ro.isdc.wro.config.support.ConfigConstants;
import ro.isdc.wro.config.support.DeploymentMode;
import ro.isdc.wro.config.support.PropertiesFactory;
import ro.isdc.wro.util.ObjectFactory;

public class FilterConfigWroConfigurationFactory
implements ObjectFactory<WroConfiguration>,
PropertiesFactory {
    private static final Logger LOG = LoggerFactory.getLogger(FilterConfigWroConfigurationFactory.class);
    public static final String PARAM_CONFIGURATION = "configuration";
    private final FilterConfig filterConfig;

    public FilterConfigWroConfigurationFactory(FilterConfig filterConfig) {
        Validate.notNull((Object)filterConfig);
        this.filterConfig = filterConfig;
    }

    @Override
    public Properties createProperties() {
        return this.createPropertiesFromFilterConfig();
    }

    protected final Properties createPropertiesFromFilterConfig() {
        Properties props = new Properties();
        for (ConfigConstants config : ConfigConstants.values()) {
            String value = this.filterConfig.getInitParameter(config.getPropertyKey());
            if (value == null) continue;
            LOG.debug("filterConfig initParam ({}), with value ({})", (Object)config.getPropertyKey(), (Object)value);
            props.setProperty(config.getPropertyKey(), value);
        }
        String configurationType = this.filterConfig.getInitParameter(PARAM_CONFIGURATION);
        if (StringUtils.isNotEmpty((CharSequence)configurationType)) {
            props.setProperty(ConfigConstants.debug.getPropertyKey(), String.valueOf(this.isDebug(configurationType)));
        }
        return props;
    }

    private boolean isDebug(String configurationType) {
        return !DeploymentMode.DEPLOYMENT.toString().equalsIgnoreCase(configurationType);
    }

    @Override
    public final WroConfiguration create() {
        return new PropertyWroConfigurationFactory(this.createProperties()).create();
    }
}

