/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.cache.factory;

import jakarta.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.Validate;
import ro.isdc.wro.cache.CacheKey;
import ro.isdc.wro.cache.factory.CacheKeyFactory;
import ro.isdc.wro.config.ReadOnlyContext;
import ro.isdc.wro.model.group.GroupExtractor;
import ro.isdc.wro.model.group.Inject;
import ro.isdc.wro.model.resource.ResourceType;

public class DefaultCacheKeyFactory
implements CacheKeyFactory {
    @Inject
    private GroupExtractor groupExtractor;
    @Inject
    private ReadOnlyContext context;

    @Override
    public CacheKey create(HttpServletRequest request) {
        Validate.notNull((Object)request);
        CacheKey key = null;
        String groupName = this.groupExtractor.getGroupName(request);
        ResourceType resourceType = this.groupExtractor.getResourceType(request);
        boolean minimize = this.isMinimized(request);
        if (groupName != null && resourceType != null) {
            key = new CacheKey(groupName, resourceType, minimize);
        }
        return key;
    }

    private boolean isMinimized(HttpServletRequest request) {
        return this.context.getConfig().isMinimizeEnabled() ? this.groupExtractor.isMinimized(request) : false;
    }
}

