/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.model.group.processor;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.isdc.wro.WroRuntimeException;
import ro.isdc.wro.model.group.Inject;
import ro.isdc.wro.model.group.processor.InjectorBuilder;
import ro.isdc.wro.util.ObjectDecorator;

public final class Injector {
    private static final Logger LOG = LoggerFactory.getLogger(Injector.class);
    private final Map<Class<?>, Object> map;
    private final Map<Object, Boolean> injectedObjects = Collections.synchronizedMap(new WeakHashMap());

    Injector(Map<Class<?>, Object> map) {
        Validate.notNull(map);
        this.map = map;
    }

    public <T> T inject(T object) {
        Validate.notNull(object);
        if (!this.injectedObjects.containsKey(this.computeKey(object))) {
            this.injectedObjects.put(this.computeKey(object), true);
            this.processInjectAnnotation(object);
        }
        return object;
    }

    private <T> int computeKey(T object) {
        return System.identityHashCode(object);
    }

    private void processInjectAnnotation(Object object) {
        try {
            Collection<Field> fields = this.getAllFields(object);
            for (Field field : fields) {
                if (!field.isAnnotationPresent(Inject.class) || this.acceptAnnotatedField(object, field)) continue;
                String message = String.format("@Inject cannot be applied on object: %s to field of type: %s using injector %s", object, field.getType(), this);
                LOG.error(message + ". Supported types are: {}", this.map.keySet());
                throw new WroRuntimeException(message);
            }
            if (object instanceof ObjectDecorator) {
                this.processInjectAnnotation(((ObjectDecorator)object).getDecoratedObject());
            }
        }
        catch (Exception e) {
            LOG.error("Error while scanning @Inject annotation", (Throwable)e);
            throw WroRuntimeException.wrap(e, "Exception while trying to process @Inject annotation on object: " + object);
        }
    }

    private Collection<Field> getAllFields(Object object) {
        ArrayList<Field> fields = new ArrayList<Field>();
        fields.addAll(Arrays.asList(object.getClass().getDeclaredFields()));
        for (Class<?> superClass = object.getClass().getSuperclass(); superClass != null; superClass = superClass.getSuperclass()) {
            fields.addAll(Arrays.asList(superClass.getDeclaredFields()));
        }
        return fields;
    }

    private boolean acceptAnnotatedField(Object object, Field field) throws IllegalAccessException {
        boolean accept = false;
        field.setAccessible(true);
        for (Map.Entry<Class<?>, Object> entry : this.map.entrySet()) {
            if (!entry.getKey().isAssignableFrom(field.getType())) continue;
            Object value = entry.getValue();
            if (value instanceof InjectorBuilder.InjectorObjectFactory) {
                value = ((InjectorBuilder.InjectorObjectFactory)value).create();
                this.inject(value);
            }
            field.set(object, value);
            accept = true;
            break;
        }
        return accept;
    }
}

