/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.util;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Properties;
import java.util.TimeZone;
import java.util.UUID;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.time.FastDateFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.isdc.wro.WroRuntimeException;
import ro.isdc.wro.model.WroModel;
import ro.isdc.wro.model.factory.WroModelFactory;
import ro.isdc.wro.model.resource.Resource;
import ro.isdc.wro.model.resource.processor.ResourcePostProcessor;
import ro.isdc.wro.model.resource.processor.ResourcePreProcessor;
import ro.isdc.wro.util.ObjectFactory;
import ro.isdc.wro.util.RegexpProperties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class WroUtil {
    private static final Logger LOG = LoggerFactory.getLogger(WroUtil.class);
    public static final Pattern EMTPY_LINE_PATTERN = Pattern.compile(WroUtil.loadRegexpWithKey("emptyLine"), 8);
    private static final FastDateFormat DATE_FORMAT = FastDateFormat.getInstance((String)"E, dd MMM yyyy HH:mm:ss z", (TimeZone)TimeZone.getTimeZone("GMT"));
    private static final Pattern PATTERN_ACCEPT_ENCODING = Pattern.compile(WroUtil.loadRegexpWithKey("requestHeader.acceptEncoding"));
    private static final Pattern PATTERN_GZIP = Pattern.compile(WroUtil.loadRegexpWithKey("requestHeader.gzip"));
    private static final AtomicInteger threadFactoryNumber = new AtomicInteger(1);
    public static final InputStream EMPTY_STREAM = new ByteArrayInputStream("".getBytes());

    public static ThreadFactory createDaemonThreadFactory(final String name) {
        return new ThreadFactory(){
            private final String prefix;
            private final AtomicInteger threadNumber;
            {
                this.prefix = "wro4j-" + name + "-" + threadFactoryNumber.getAndIncrement() + "-thread-";
                this.threadNumber = new AtomicInteger(1);
            }

            public Thread newThread(Runnable runnable) {
                Thread thread = new Thread(runnable, this.prefix + this.threadNumber.getAndIncrement());
                thread.setDaemon(true);
                return thread;
            }
        };
    }

    public static String toDateAsString(long milliseconds) {
        return DATE_FORMAT.format(milliseconds);
    }

    public static String getPathInfoFromLocation(HttpServletRequest request, String location) {
        if (StringUtils.isEmpty((CharSequence)location)) {
            throw new IllegalArgumentException("Location cannot be empty string!");
        }
        String contextPath = request.getContextPath();
        if (contextPath != null) {
            if (WroUtil.startsWithIgnoreCase(location, contextPath)) {
                return location.substring(contextPath.length());
            }
            return location;
        }
        String noSlash = location.substring(1);
        int nextSlash = noSlash.indexOf(47);
        if (nextSlash == -1) {
            return "";
        }
        String pathInfo = noSlash.substring(nextSlash);
        return pathInfo;
    }

    public static boolean startsWithIgnoreCase(String str, String prefix) {
        return WroUtil.startsWith(str, prefix, true);
    }

    public static String toPackageAsFolder(Class<?> clazz) {
        Validate.notNull(clazz, (String)"Class cannot be null!", (Object[])new Object[0]);
        return clazz.getPackage().getName().replace('.', '/');
    }

    private static boolean startsWith(String str, String prefix, boolean ignoreCase) {
        if (str == null || prefix == null) {
            return str == null && prefix == null;
        }
        if (prefix.length() > str.length()) {
            return false;
        }
        return str.regionMatches(ignoreCase, 0, prefix, 0, prefix.length());
    }

    public static String getServletPathFromLocation(HttpServletRequest request, String location) {
        return location.replace(WroUtil.getPathInfoFromLocation(request, location), "");
    }

    public static boolean isGzipSupported(HttpServletRequest request) {
        Enumeration headerNames;
        if (request != null && (headerNames = request.getHeaderNames()) != null) {
            while (headerNames.hasMoreElements()) {
                String headerName = (String)headerNames.nextElement();
                Matcher m = PATTERN_ACCEPT_ENCODING.matcher(headerName);
                if (!m.find()) continue;
                String headerValue = request.getHeader(headerName);
                Matcher mValue = PATTERN_GZIP.matcher(headerValue);
                return mValue.find();
            }
        }
        return false;
    }

    public static String toJSMultiLineString(String data) {
        String[] lines = data.split("\n");
        StringBuffer result = new StringBuffer("[");
        if (lines.length == 0) {
            result.append("\"\"");
        }
        for (int i = 0; i < lines.length; ++i) {
            String line = lines[i];
            result.append("\"");
            result.append(line.replace("\\", "\\\\").replace("\"", "\\\"").replaceAll("\\r|\\n", ""));
            if (lines.length == 1) {
                result.append("\\n");
            }
            result.append("\"");
            if (i >= lines.length - 1) continue;
            result.append(",");
        }
        result.append("].join(\"\\n\")");
        return result.toString();
    }

    public static boolean matchesUrl(HttpServletRequest request, String path) {
        Pattern pattern = Pattern.compile(".*" + path + "[/]?", 2);
        if (request.getRequestURI() != null) {
            Matcher m = pattern.matcher(request.getRequestURI());
            return m.matches();
        }
        return false;
    }

    public static ResourcePostProcessor newResourceProcessor(final Resource resource, final ResourcePreProcessor preProcessor) {
        return new ResourcePostProcessor(){

            public void process(Reader reader, Writer writer) throws IOException {
                preProcessor.process(resource, reader, writer);
            }
        };
    }

    public static WroModelFactory factoryFor(final WroModel model) {
        return new WroModelFactory(){

            public WroModel create() {
                return model;
            }

            public void destroy() {
            }
        };
    }

    public static <T> ObjectFactory<T> simpleObjectFactory(final T object) {
        return new ObjectFactory<T>(){

            @Override
            public T create() {
                return object;
            }
        };
    }

    @Deprecated
    public static void wrapWithWroRuntimeException(Exception e) {
        LOG.error("Exception occured: " + e.getClass(), e.getCause());
        if (e instanceof WroRuntimeException) {
            throw (WroRuntimeException)e;
        }
        throw new WroRuntimeException(e.getMessage(), e);
    }

    public static String loadRegexpWithKey(String key) {
        try {
            InputStream stream = WroUtil.class.getResourceAsStream("regexp.properties");
            Properties props = new RegexpProperties().load(stream);
            return props.getProperty(key);
        }
        catch (IOException e) {
            throw new WroRuntimeException("Could not load pattern with key: " + key + " from property file", e);
        }
    }

    public static String getImplementationVersion() {
        return WroUtil.class.getPackage().getImplementationVersion();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void safeCopy(Reader reader, Writer writer) throws IOException {
        try {
            IOUtils.copy((Reader)reader, (Writer)writer);
        }
        finally {
            IOUtils.closeQuietly((Reader)reader);
            IOUtils.closeQuietly((Writer)writer);
        }
    }

    public static File createTempFile() {
        return new File(FileUtils.getTempDirectory(), "wro4j" + UUID.randomUUID().toString());
    }
}

