/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.model.resource.processor.impl.css;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.input.AutoCloseInputStream;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.isdc.wro.config.jmx.WroConfiguration;
import ro.isdc.wro.model.group.Inject;
import ro.isdc.wro.model.group.processor.PreProcessorExecutor;
import ro.isdc.wro.model.resource.Resource;
import ro.isdc.wro.model.resource.ResourceType;
import ro.isdc.wro.model.resource.SupportedResourceType;
import ro.isdc.wro.model.resource.locator.factory.UriLocatorFactory;
import ro.isdc.wro.model.resource.processor.ResourcePreProcessor;
import ro.isdc.wro.util.StringUtils;
import ro.isdc.wro.util.WroUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@SupportedResourceType(value=ResourceType.CSS)
public class CssImportPreProcessor
implements ResourcePreProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(CssImportPreProcessor.class);
    public static final String ALIAS = "cssImport";
    @Inject
    private UriLocatorFactory uriLocatorFactory;
    @Inject
    private PreProcessorExecutor preProcessorExecutor;
    @Inject
    private WroConfiguration configuration;
    private final ThreadLocal<List<String>> processedImports = new ThreadLocal<List<String>>(){

        @Override
        protected List<String> initialValue() {
            return new ArrayList<String>();
        }
    };
    private static final Pattern PATTERN = Pattern.compile(WroUtil.loadRegexpWithKey("cssImport"));
    private static final String REGEX_IMPORT_FROM_COMMENTS = WroUtil.loadRegexpWithKey("cssImportFromComments");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(Resource resource, Reader reader, Writer writer) throws IOException {
        LOG.debug("Applying {} processor", (Object)this.getClass().getSimpleName());
        this.validate();
        try {
            String result = this.parseCss(resource, reader);
            writer.write(result);
            this.getProcessedList().clear();
        }
        finally {
            reader.close();
            writer.close();
        }
    }

    private List<String> getProcessedList() {
        return this.processedImports.get();
    }

    private void validate() {
        Validate.notNull((Object)this.uriLocatorFactory);
        Validate.notNull((Object)this.preProcessorExecutor);
    }

    private String parseCss(Resource resource, Reader reader) throws IOException {
        if (this.getProcessedList().contains(resource.getUri())) {
            LOG.debug("[WARN] Recursive import detected: {}", (Object)resource);
            this.onRecursiveImportDetected();
            return "";
        }
        this.getProcessedList().add(resource.getUri().replace(File.separatorChar, '/'));
        StringBuffer sb = new StringBuffer();
        List<Resource> importsCollector = this.getImportedResources(resource);
        sb.append(this.preProcessorExecutor.processAndMerge(importsCollector, true));
        if (!importsCollector.isEmpty()) {
            LOG.debug("Imported resources found : {}", (Object)importsCollector.size());
        }
        sb.append(IOUtils.toString((Reader)reader));
        LOG.debug("importsCollector: {}", importsCollector);
        return this.removeImportStatements(sb.toString());
    }

    protected void onRecursiveImportDetected() {
    }

    private String removeImportStatements(String content) {
        Matcher m = PATTERN.matcher(content);
        StringBuffer sb = new StringBuffer();
        while (m.find()) {
            m.appendReplacement(sb, "");
        }
        m.appendTail(sb);
        return sb.toString();
    }

    private List<Resource> getImportedResources(Resource resource) throws IOException {
        String css;
        ArrayList<Resource> imports;
        block4: {
            imports = new ArrayList<Resource>();
            css = "";
            try {
                css = IOUtils.toString((InputStream)new AutoCloseInputStream(this.uriLocatorFactory.locate(resource.getUri())), (String)this.configuration.getEncoding());
            }
            catch (IOException e) {
                if (this.configuration.isIgnoreMissingResources()) break block4;
                LOG.error("Invalid import detected: {}", (Object)resource.getUri());
                throw e;
            }
        }
        css = css.replaceAll(REGEX_IMPORT_FROM_COMMENTS, "");
        Matcher m = PATTERN.matcher(css);
        while (m.find()) {
            Resource importedResource = this.buildImportedResource(resource.getUri(), m.group(1));
            if (imports.contains(importedResource)) {
                LOG.debug("[WARN] Duplicate imported resource: {}", (Object)importedResource);
                continue;
            }
            imports.add(importedResource);
        }
        return imports;
    }

    private Resource buildImportedResource(String resourceUri, String importUrl) {
        String absoluteUrl = this.computeAbsoluteUrl(resourceUri, importUrl);
        return Resource.create(absoluteUrl, ResourceType.CSS);
    }

    private String computeAbsoluteUrl(String relativeResourceUri, String importUrl) {
        String folder = FilenameUtils.getFullPath((String)relativeResourceUri);
        String absoluteImportUrl = StringUtils.cleanPath(folder + importUrl);
        return absoluteImportUrl;
    }
}

