/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.model.resource.processor.decorator;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import org.apache.commons.lang3.Validate;
import ro.isdc.wro.model.resource.Resource;
import ro.isdc.wro.model.resource.ResourceType;
import ro.isdc.wro.model.resource.SupportedResourceType;
import ro.isdc.wro.model.resource.processor.ResourcePostProcessor;
import ro.isdc.wro.model.resource.processor.ResourcePreProcessor;
import ro.isdc.wro.model.resource.processor.decorator.AbstractProcessorDecoratorSupport;

public class ProcessorDecorator
extends AbstractProcessorDecoratorSupport {
    private final ResourcePreProcessor decoratedProcessor;

    public ProcessorDecorator(Object processor) {
        Validate.notNull((Object)processor);
        if (processor instanceof ResourcePreProcessor) {
            this.decoratedProcessor = (ResourcePreProcessor)processor;
        } else if (processor instanceof ResourcePostProcessor) {
            this.decoratedProcessor = this.toPreProcessor((ResourcePostProcessor)processor);
        } else {
            throw new IllegalArgumentException("Invalid processor: " + processor);
        }
    }

    private ResourcePreProcessor toPreProcessor(final ResourcePostProcessor postProcessor) {
        return new AbstractProcessorDecoratorSupport(){

            public Object getDecoratedObject() {
                return postProcessor;
            }

            public void process(Resource resource, Reader reader, Writer writer) throws IOException {
                postProcessor.process(reader, writer);
            }

            protected boolean isMinimizeInternal() {
                return this.isMinimizeForProcessor(postProcessor);
            }

            protected SupportedResourceType getSupportedResourceTypeInternal() {
                return this.getSupportedResourceTypeForProcessor(postProcessor);
            }
        };
    }

    public final ResourcePreProcessor getDecoratedObject() {
        return this.decoratedProcessor;
    }

    public void process(Resource resource, Reader reader, Writer writer) throws IOException {
        this.decoratedProcessor.process(resource, reader, writer);
    }

    public final boolean isEligible(boolean minimize, ResourceType searchedType) {
        Validate.notNull((Object)((Object)searchedType));
        SupportedResourceType supportedType = this.getSupportedResourceType();
        boolean isTypeSatisfied = supportedType == null || supportedType != null && searchedType == supportedType.value();
        boolean isMinimizedSatisfied = minimize || !this.isMinimize();
        return isTypeSatisfied && isMinimizedSatisfied;
    }

    public String toString() {
        return this.getOriginalDecoratedObject().toString();
    }
}

