/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.model.resource.locator;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.isdc.wro.config.ReadOnlyContext;
import ro.isdc.wro.model.group.Inject;
import ro.isdc.wro.model.resource.locator.support.DispatcherStreamLocator;
import ro.isdc.wro.model.resource.locator.wildcard.WildcardUriLocatorSupport;
import ro.isdc.wro.model.transformer.WildcardExpanderModelTransformer;
import ro.isdc.wro.util.WroUtil;

public class ServletContextUriLocator
extends WildcardUriLocatorSupport {
    private static final Logger LOG = LoggerFactory.getLogger(ServletContextUriLocator.class);
    public static final String ALIAS = "servletContext";
    public static final String ALIAS_DISPATCHER_FIRST = "servletContext.DISPATCHER_FIRST";
    public static final String ALIAS_SERVLET_CONTEXT_FIRST = "servletContext.SERVLET_CONTEXT_FIRST";
    public static final String PREFIX = "/";
    private static final String PROTECTED_PREFIX = "/WEB-INF/";
    private final DispatcherStreamLocator dispatcherStreamLocator = new DispatcherStreamLocator();
    private LocatorStrategy locatorStrategy = LocatorStrategy.DISPATCHER_FIRST;
    @Inject
    private ReadOnlyContext context;

    public ServletContextUriLocator setLocatorStrategy(LocatorStrategy locatorStrategy) {
        Validate.notNull((Object)((Object)locatorStrategy));
        this.locatorStrategy = locatorStrategy;
        return this;
    }

    public boolean accept(String uri) {
        return ServletContextUriLocator.isValid(uri);
    }

    public static boolean isValid(String uri) {
        return uri.trim().startsWith(PREFIX);
    }

    public static boolean isProtectedResource(String uri) {
        return WroUtil.startsWithIgnoreCase(uri, PROTECTED_PREFIX);
    }

    public InputStream locate(String uri) throws IOException {
        Validate.notNull((Object)uri, (String)"URI cannot be NULL!", (Object[])new Object[0]);
        LOG.debug("locate resource: {}", (Object)uri);
        try {
            if (this.getWildcardStreamLocator().hasWildcard(uri)) {
                String fullPath;
                ServletContext servletContext = this.context.getServletContext();
                String realPath = servletContext.getRealPath(fullPath = FilenameUtils.getFullPath((String)uri));
                if (realPath == null) {
                    String message = "[FAIL] determine realPath for resource: " + uri;
                    LOG.debug(message);
                    throw new IOException(message);
                }
                return this.getWildcardStreamLocator().locateStream(uri, new File(realPath));
            }
        }
        catch (IOException e) {
            if (e instanceof WildcardExpanderModelTransformer.NoMoreAttemptsIOException) {
                throw e;
            }
            LOG.warn("[FAIL] localize the stream containing wildcard. Original error message: '{}'", (Object)(e.getMessage() + "\".\n Trying to locate the stream without the wildcard."));
        }
        InputStream inputStream = null;
        try {
            inputStream = this.locatorStrategy.equals((Object)LocatorStrategy.DISPATCHER_FIRST) ? this.dispatcherFirstStreamLocator(uri) : this.servletContextFirstStreamLocator(uri);
            this.validateInputStreamIsNotNull(inputStream, uri);
            return inputStream;
        }
        catch (IOException e) {
            LOG.debug("Wrong or empty resource with location: {}", (Object)uri);
            throw e;
        }
    }

    private InputStream servletContextFirstStreamLocator(String uri) throws IOException {
        try {
            return this.servletContextBasedStreamLocator(uri);
        }
        catch (IOException e) {
            LOG.debug("retrieving servletContext stream for uri: {}", (Object)uri);
            return this.dispatcherBasedStreamLocator(uri);
        }
    }

    private InputStream dispatcherFirstStreamLocator(String uri) throws IOException {
        try {
            return this.dispatcherBasedStreamLocator(uri);
        }
        catch (IOException e) {
            LOG.debug("retrieving servletContext stream for uri: {}", (Object)uri);
            return this.servletContextBasedStreamLocator(uri);
        }
    }

    private InputStream dispatcherBasedStreamLocator(String uri) throws IOException {
        HttpServletRequest request = this.context.getRequest();
        HttpServletResponse response = this.context.getResponse();
        return this.dispatcherStreamLocator.getInputStream(request, response, uri);
    }

    private InputStream servletContextBasedStreamLocator(String uri) throws IOException {
        ServletContext servletContext = this.context.getServletContext();
        return servletContext.getResourceAsStream(uri);
    }

    private void validateInputStreamIsNotNull(InputStream inputStream, String uri) throws IOException {
        if (inputStream == null) {
            LOG.debug("[FAIL] reading resource from {}", (Object)uri);
            throw new IOException("Exception while reading resource from " + uri);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum LocatorStrategy {
        DISPATCHER_FIRST,
        SERVLET_CONTEXT_FIRST;

    }
}

