/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.manager.callback;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.isdc.wro.manager.callback.LifecycleCallback;

public class LifecycleCallbackRegistry
implements LifecycleCallback {
    private static final Logger LOG = LoggerFactory.getLogger(LifecycleCallbackRegistry.class);
    private List<LifecycleCallback> callbacks = new ArrayList<LifecycleCallback>();

    public void registerCallback(LifecycleCallback callback) {
        Validate.notNull((Object)callback);
        this.callbacks.add(callback);
    }

    public void onBeforeModelCreated() {
        for (LifecycleCallback callback : this.callbacks) {
            try {
                callback.onBeforeModelCreated();
            }
            catch (Exception e) {
                LOG.error("Problem invoking onBeforeModelCreated", (Throwable)e);
            }
        }
    }

    public void onAfterModelCreated() {
        for (LifecycleCallback callback : this.callbacks) {
            try {
                callback.onAfterModelCreated();
            }
            catch (Exception e) {
                LOG.error("Problem invoking onAfterModelCreated", (Throwable)e);
            }
        }
    }

    public void onBeforePreProcess() {
        for (LifecycleCallback callback : this.callbacks) {
            try {
                callback.onBeforePreProcess();
            }
            catch (Exception e) {
                LOG.error("Problem invoking onBeforePreProcess", (Throwable)e);
            }
        }
    }

    public void onAfterPreProcess() {
        for (LifecycleCallback callback : this.callbacks) {
            try {
                callback.onAfterPreProcess();
            }
            catch (Exception e) {
                LOG.error("Problem invoking onAfterPreProcess", (Throwable)e);
            }
        }
    }

    public void onBeforePostProcess() {
        for (LifecycleCallback callback : this.callbacks) {
            try {
                callback.onBeforePostProcess();
            }
            catch (Exception e) {
                LOG.error("Problem invoking onBeforePostProcess", (Throwable)e);
            }
        }
    }

    public void onAfterPostProcess() {
        for (LifecycleCallback callback : this.callbacks) {
            try {
                callback.onAfterPostProcess();
            }
            catch (Exception e) {
                LOG.error("Problem invoking onAfterPostProcess", (Throwable)e);
            }
        }
    }

    public void onBeforeMerge() {
        for (LifecycleCallback callback : this.callbacks) {
            try {
                callback.onBeforeMerge();
            }
            catch (Exception e) {
                LOG.error("Problem invoking onBeforeMerge", (Throwable)e);
            }
        }
    }

    public void onAfterMerge() {
        for (LifecycleCallback callback : this.callbacks) {
            try {
                callback.onAfterMerge();
            }
            catch (Exception e) {
                LOG.error("Problem invoking onAfterMerge", (Throwable)e);
            }
        }
    }

    public void onProcessingComplete() {
        for (LifecycleCallback callback : this.callbacks) {
            try {
                callback.onProcessingComplete();
            }
            catch (Exception e) {
                LOG.error("Problem invoking onProcessingComplete", (Throwable)e);
            }
        }
    }
}

