/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.http.support;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.activation.FileTypeMap;
import org.apache.commons.io.FilenameUtils;

public class ContentTypeResolver {
    private static final FileTypeMap systemFileTypeMap = FileTypeMap.getDefaultFileTypeMap();
    private static final Map<String, String> defaultContentTypeMap = new HashMap<String, String>();
    private static final Set<String> requiresCharset = new HashSet<String>();

    public static String get(String fileName) {
        String extension = FilenameUtils.getExtension((String)fileName).toLowerCase();
        if (defaultContentTypeMap.containsKey(extension)) {
            return defaultContentTypeMap.get(extension);
        }
        return systemFileTypeMap.getContentType(fileName);
    }

    public static String get(String fileName, String encoding) {
        String contentType = ContentTypeResolver.get(fileName);
        if (requiresCharset.contains(contentType)) {
            return contentType + "; charset=" + encoding;
        }
        return contentType;
    }

    static {
        defaultContentTypeMap.put("txt", "text/plain");
        defaultContentTypeMap.put("css", "text/css");
        defaultContentTypeMap.put("html", "text/html");
        defaultContentTypeMap.put("htm", "text/html");
        defaultContentTypeMap.put("xml", "application/xml");
        defaultContentTypeMap.put("xhtml", "application/xhtml+xml");
        defaultContentTypeMap.put("js", "application/javascript");
        defaultContentTypeMap.put("png", "image/png");
        defaultContentTypeMap.put("gif", "image/gif");
        defaultContentTypeMap.put("jpg", "image/jpeg");
        defaultContentTypeMap.put("jpeg", "image/jpeg");
        defaultContentTypeMap.put("eot", "application/vnd.ms-fontobject");
        defaultContentTypeMap.put("otf", "application/x-font-opentype");
        requiresCharset.add("text/css");
        requiresCharset.add("text/html");
        requiresCharset.add("text/plain");
        requiresCharset.add("application/xml");
        requiresCharset.add("application/xhtml+xml");
        requiresCharset.add("application/javascript");
    }
}

