/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.config.support;

import java.util.concurrent.Callable;
import org.apache.commons.lang3.Validate;
import ro.isdc.wro.config.Context;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContextPropagatingCallable<T>
implements Callable<T> {
    private final String correlationId;
    private final Callable<T> decorated;

    public ContextPropagatingCallable(Callable<T> decorated) {
        Validate.notNull(decorated);
        this.decorated = decorated;
        this.correlationId = Context.getCorrelationId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T call() throws Exception {
        Context.setCorrelationId(this.correlationId);
        try {
            T t = this.decorated.call();
            return t;
        }
        finally {
            Context.unsetCorrelationId();
        }
    }
}

