/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.cache;

import java.util.Map;
import ro.isdc.wro.cache.CacheEntry;
import ro.isdc.wro.cache.CacheStrategy;
import ro.isdc.wro.cache.ContentHashEntry;
import ro.isdc.wro.cache.impl.LruMemoryCacheStrategy;
import ro.isdc.wro.cache.spi.CacheStrategyProvider;
import ro.isdc.wro.model.group.Inject;
import ro.isdc.wro.model.group.processor.Injector;
import ro.isdc.wro.model.resource.support.AbstractConfigurableSingleStrategy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigurableCacheStrategy
extends AbstractConfigurableSingleStrategy<CacheStrategy, CacheStrategyProvider>
implements CacheStrategy<CacheEntry, ContentHashEntry> {
    public static final String KEY = "cacheStrategy";
    @Inject
    private Injector injector;
    private CacheStrategy<CacheEntry, ContentHashEntry> decorated;

    @Override
    public void clear() {
        this.getDecoratedStrategy().clear();
    }

    @Override
    public void destroy() {
        this.getDecoratedStrategy().destroy();
    }

    @Override
    public ContentHashEntry get(CacheEntry key) {
        return this.getDecoratedStrategy().get(key);
    }

    @Override
    public void put(CacheEntry key, ContentHashEntry value) {
        this.getDecoratedStrategy().put(key, value);
    }

    private CacheStrategy<CacheEntry, ContentHashEntry> getDecoratedStrategy() {
        if (this.decorated == null) {
            this.decorated = (CacheStrategy)this.getConfiguredStrategy();
            this.injector.inject(this.decorated);
        }
        return this.decorated;
    }

    @Override
    protected String getStrategyKey() {
        return KEY;
    }

    @Override
    protected CacheStrategy<CacheEntry, ContentHashEntry> getDefaultStrategy() {
        return new LruMemoryCacheStrategy<CacheEntry, ContentHashEntry>();
    }

    @Override
    protected Map<String, CacheStrategy> getStrategies(CacheStrategyProvider provider) {
        return provider.provideCacheStrategies();
    }

    @Override
    protected Class<CacheStrategyProvider> getProviderClass() {
        return CacheStrategyProvider.class;
    }
}

