/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.jsp.zul.impl;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.zkoss.util.logging.Log;
import org.zkoss.zk.ui.Page;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.util.Initiator;

public class Initiators {
    static final Log log = Log.lookup((Class)Initiators.class);
    private final List _inits = new LinkedList();

    public void addInitiator(Initiator init, List args) {
        this._inits.add(new Object[]{init, args});
    }

    public void doInit(Page page) {
        Iterator it = this._inits.iterator();
        while (it.hasNext()) {
            Object[] objArr = (Object[])it.next();
            Initiator initiator = (Initiator)objArr[0];
            List args = (List)objArr[1];
            try {
                initiator.doInit(page, args.toArray());
            }
            catch (Throwable ex) {
                throw UiException.Aide.wrap((Throwable)ex);
            }
        }
    }

    public void doAfterCompose(Page page) throws Exception {
        Iterator it = this._inits.iterator();
        while (it.hasNext()) {
            ((Initiator)((Object[])it.next())[0]).doAfterCompose(page);
        }
    }

    public void doCatch(Throwable t) {
        Iterator it = this._inits.iterator();
        while (it.hasNext()) {
            Initiator init = (Initiator)((Object[])it.next())[0];
            try {
                init.doCatch(t);
            }
            catch (Throwable ex) {
                log.error(ex);
            }
        }
    }

    public void doFinally() {
        Throwable t = null;
        Iterator it = this._inits.iterator();
        while (it.hasNext()) {
            Initiator init = (Initiator)((Object[])it.next())[0];
            try {
                init.doFinally();
            }
            catch (Throwable ex) {
                log.error(ex);
                if (t != null) continue;
                t = ex;
            }
        }
        if (t != null) {
            throw UiException.Aide.wrap(t);
        }
    }
}

