/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.jsf.zul.impl;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.zkoss.jsf.zul.impl.AbstractComponent;
import org.zkoss.jsf.zul.impl.ComponentInfo;
import org.zkoss.jsf.zul.impl.Inline;
import org.zkoss.jsf.zul.impl.LeafComponent;
import org.zkoss.lang.Objects;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Page;

class Utils {
    private static final String MARK_PREFIX = "<zk~f[";
    private static final String MARK_POSTFIX = "]>";

    Utils() {
    }

    static void adjustChildren(Page page, AbstractComponent parent, Collection children, String body) {
        int len;
        Iterator it = new ArrayList(children).iterator();
        ComponentInfo cinfo = parent.getComponentInfo();
        int j = 0;
        int n = len = body != null ? body.length() : 0;
        while (j < len) {
            int k = body.indexOf(MARK_PREFIX, j);
            String txt = null;
            LeafComponent child = null;
            if (k >= 0) {
                int l = k + MARK_PREFIX.length();
                int m = body.indexOf(MARK_POSTFIX, l);
                if (m <= l) {
                    k = -1;
                } else {
                    txt = body.substring(j, k).trim();
                    child = Utils.matchNextLeafComponent(it, cinfo.getRegistedComponent(body.substring(l, m)));
                    k = m + MARK_POSTFIX.length();
                }
            }
            if (k < 0) {
                txt = body.substring(j).trim();
            }
            if (txt.length() > 0) {
                Inline inl = new Inline(txt);
                if (child != null) {
                    if (parent != null && parent instanceof LeafComponent) {
                        ((LeafComponent)parent).getZULComponent().insertBefore((Component)inl, child.getZULComponent());
                    } else {
                        inl.setPageBefore(page, child.getZULComponent());
                    }
                } else if (parent != null && parent instanceof LeafComponent) {
                    ((LeafComponent)parent).getZULComponent().appendChild((Component)inl);
                } else {
                    inl.setPage(page);
                }
            }
            if (k < 0) break;
            j = k;
        }
    }

    private static LeafComponent matchNextLeafComponent(Iterator it, AbstractComponent child) {
        while (it.hasNext()) {
            AbstractComponent nextchild = (AbstractComponent)((Object)it.next());
            if (!(nextchild instanceof LeafComponent)) continue;
            if (Objects.equals((Object)((Object)nextchild), (Object)((Object)child))) {
                return (LeafComponent)nextchild;
            }
            Component comp = ((LeafComponent)nextchild).getZULComponent();
            if (comp == null) continue;
            comp.detach();
        }
        return null;
    }

    static void writeComponentMark(Writer out, AbstractComponent comp) throws IOException {
        String uid = comp.getComponentInfo().registerComponent(comp);
        out.write(MARK_PREFIX);
        out.write(uid);
        out.write(MARK_POSTFIX);
    }

    static void renderComponent(UIComponent component, FacesContext context) throws IOException {
        if (!component.isRendered()) {
            return;
        }
        if (component instanceof AbstractComponent && !((AbstractComponent)component).isEffective()) {
            return;
        }
        component.encodeBegin(context);
        if (component.getRendersChildren()) {
            component.encodeChildren(context);
        } else {
            Iterator kids = component.getChildren().iterator();
            while (kids.hasNext()) {
                UIComponent kid = (UIComponent)kids.next();
                Utils.renderComponent(kid, context);
            }
        }
        component.encodeEnd(context);
    }
}

