/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul;

import java.io.IOException;
import javax.swing.SpinnerNumberModel;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.WrongValueException;
import org.zkoss.zk.ui.sys.ContentRenderer;
import org.zkoss.zul.SimpleSpinnerConstraint;
import org.zkoss.zul.impl.NumberInputElement;
import org.zkoss.zul.mesg.MZul;

public class Spinner
extends NumberInputElement
implements org.zkoss.zul.api.Spinner {
    private int _step = 1;
    private boolean _btnVisible = true;

    public Spinner() {
        this.setCols(11);
    }

    public Spinner(int value) throws WrongValueException {
        this();
        this.setValue(new Integer(value));
    }

    public Spinner(SpinnerNumberModel model) {
        this.setCols(11);
    }

    public Integer getValue() throws WrongValueException {
        return (Integer)this.getTargetValue();
    }

    public int intValue() throws WrongValueException {
        Object val = this.getTargetValue();
        return val != null ? (Integer)val : 0;
    }

    public void setValue(Integer value) throws WrongValueException {
        this.validate(value);
        this.setRawValue(value);
    }

    public int getStep() {
        return this._step;
    }

    public void setStep(int step) {
        if (this._step != step) {
            this._step = step;
            this.smartUpdate("step", this._step);
        }
    }

    public boolean isButtonVisible() {
        return this._btnVisible;
    }

    public void setButtonVisible(boolean visible) {
        if (this._btnVisible != visible) {
            this._btnVisible = visible;
            this.smartUpdate("buttonVisible", visible);
        }
    }

    public String getZclass() {
        return this._zclass == null ? "z-spinner" : this._zclass;
    }

    public void setConstraint(String constr) {
        this.setConstraint(constr != null ? new SimpleSpinnerConstraint(constr) : null);
    }

    protected Object coerceFromString(String value) throws WrongValueException {
        Object[] vals = this.toNumberOnly(value);
        String val = (String)vals[0];
        if (val == null || val.length() == 0) {
            return null;
        }
        try {
            int v;
            int divscale;
            int n = divscale = vals[1] != null ? (Integer)vals[1] : 0;
            for (v = Integer.parseInt(val); v != 0 && --divscale >= 0; v /= 10) {
            }
            return new Integer(v);
        }
        catch (NumberFormatException ex) {
            throw this.showCustomError(new WrongValueException((Component)this, MZul.NUMBER_REQUIRED, (Object)value));
        }
    }

    protected String coerceToString(Object value) {
        return value != null && this.getFormat() == null ? value.toString() : this.formatNumber(value, null);
    }

    protected void renderProperties(ContentRenderer renderer) throws IOException {
        super.renderProperties(renderer);
        if (this._step != 1) {
            renderer.render("step", this._step);
        }
        if (!this._btnVisible) {
            renderer.render("buttonVisible", this._btnVisible);
        }
    }
}

