/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.zkoss.lang.Classes;
import org.zkoss.lang.Objects;
import org.zkoss.lang.Strings;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Components;
import org.zkoss.zk.ui.Page;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.WrongValueException;
import org.zkoss.zk.ui.ext.Scope;
import org.zkoss.zk.ui.ext.Scopes;
import org.zkoss.zk.ui.sys.ContentRenderer;
import org.zkoss.zul.FieldComparator;
import org.zkoss.zul.GroupsListModel;
import org.zkoss.zul.ListModel;
import org.zkoss.zul.ListModelExt;
import org.zkoss.zul.Listbox;
import org.zkoss.zul.Listgroup;
import org.zkoss.zul.Listhead;
import org.zkoss.zul.ListitemComparator;
import org.zkoss.zul.impl.HeaderElement;

public class Listheader
extends HeaderElement
implements org.zkoss.zul.api.Listheader {
    private static final long serialVersionUID = 20080218L;
    private String _sortDir = "natural";
    private transient Comparator _sortAsc;
    private transient Comparator _sortDsc;
    private String _sortAscNm = "none";
    private String _sortDscNm = "none";
    private Object _value;
    private int _maxlength;

    public Listheader() {
    }

    public Listheader(String label) {
        super(label);
    }

    public Listheader(String label, String src) {
        super(label, src);
    }

    public Listheader(String label, String src, String width) {
        super(label, src);
        this.setWidth(width);
    }

    public Listbox getListbox() {
        Component comp = this.getParent();
        return comp != null ? (Listbox)comp.getParent() : null;
    }

    public org.zkoss.zul.api.Listbox getListboxApi() {
        return this.getListbox();
    }

    public Object getValue() {
        return this._value;
    }

    public void setValue(Object value) {
        this._value = value;
    }

    public String getSortDirection() {
        return this._sortDir;
    }

    public void setSortDirection(String sortDir) throws WrongValueException {
        if (sortDir == null || !"ascending".equals(sortDir) && !"descending".equals(sortDir) && !"natural".equals(sortDir)) {
            throw new WrongValueException("Unknown sort direction: " + sortDir);
        }
        if (!Objects.equals((Object)this._sortDir, (Object)sortDir)) {
            this._sortDir = sortDir;
            this.smartUpdate("sortDirection", this._sortDir);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setSort(String type) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        if (type == null) {
            return;
        }
        if (type.startsWith("client")) {
            this.setSortAscending(type);
            this.setSortDescending(type);
            return;
        } else if ("auto".equals(type)) {
            if (this.getSortAscending() == null) {
                this.setSortAscending(new ListitemComparator(this, true, true));
            }
            if (this.getSortDescending() != null) return;
            this.setSortDescending(new ListitemComparator(this, false, true));
            return;
        } else if (!Strings.isBlank((String)type) && type.startsWith("auto")) {
            int j = type.indexOf(40);
            int k = type.lastIndexOf(41);
            if (j < 0 || k < 0) throw new UiException("Unknown sort type: " + type);
            String fieldnames = type.substring(j + 1, k);
            if (this.getSortAscending() == null) {
                this.setSortAscending(new FieldComparator(fieldnames, true));
            }
            if (this.getSortDescending() != null) return;
            this.setSortDescending(new FieldComparator(fieldnames, false));
            return;
        } else {
            if (!"none".equals(type)) return;
            this.setSortAscending((Comparator)null);
            this.setSortDescending((Comparator)null);
        }
    }

    public Comparator getSortAscending() {
        return this._sortAsc;
    }

    public void setSortAscending(Comparator sorter) {
        if (!Objects.equals((Object)this._sortAsc, (Object)sorter)) {
            String nm;
            this._sortAsc = sorter;
            String string = nm = this._sortAsc == null ? "none" : "fromServer";
            if (!this._sortAscNm.equals(nm)) {
                this._sortAscNm = nm;
                this.smartUpdate("sortAscending", this._sortAscNm);
            }
        }
    }

    public void setSortAscending(String clsnm) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        if (!Strings.isBlank((String)clsnm) && clsnm.startsWith("client") && !this._sortAscNm.equals(clsnm)) {
            this._sortAscNm = clsnm;
            this.smartUpdate("sortAscending", clsnm);
        } else {
            this.setSortAscending(this.toComparator(clsnm));
        }
    }

    public Comparator getSortDescending() {
        return this._sortDsc;
    }

    public void setSortDescending(Comparator sorter) {
        if (!Objects.equals((Object)this._sortDsc, (Object)sorter)) {
            String nm;
            this._sortDsc = sorter;
            String string = nm = this._sortDsc == null ? "none" : "fromServer";
            if (!this._sortDscNm.equals(nm)) {
                this._sortDscNm = nm;
                this.smartUpdate("sortDescending", this._sortDscNm);
            }
        }
    }

    public void setSortDescending(String clsnm) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        if (!Strings.isBlank((String)clsnm) && clsnm.startsWith("client") && !this._sortDscNm.equals(clsnm)) {
            this._sortDscNm = clsnm;
            this.smartUpdate("sortDescending", clsnm);
        } else {
            this.setSortDescending(this.toComparator(clsnm));
        }
    }

    private Comparator toComparator(String clsnm) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        Class cls;
        if (clsnm == null || clsnm.length() == 0) {
            return null;
        }
        Page page = this.getPage();
        Class clazz = cls = page != null ? page.getZScriptClass(clsnm) : Classes.forNameByThread((String)clsnm);
        if (cls == null) {
            throw new ClassNotFoundException(clsnm);
        }
        if (!Comparator.class.isAssignableFrom(cls)) {
            throw new UiException("Comparator must be implemented: " + clsnm);
        }
        return (Comparator)cls.newInstance();
    }

    public int getMaxlength() {
        return this._maxlength;
    }

    public void setMaxlength(int maxlength) {
        if (maxlength < 0) {
            maxlength = 0;
        }
        if (this._maxlength != maxlength) {
            this._maxlength = maxlength;
            this.smartUpdate("maxlength", maxlength);
        }
    }

    public int getColumnIndex() {
        int j = 0;
        Iterator it = this.getParent().getChildren().iterator();
        while (it.hasNext() && it.next() != this) {
            ++j;
        }
        return j;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean sort(boolean ascending) {
        Comparator cmpr;
        String dir = this.getSortDirection();
        if (ascending ? "ascending".equals(dir) : "descending".equals(dir)) {
            return false;
        }
        Comparator comparator = cmpr = ascending ? this._sortAsc : this._sortDsc;
        if (cmpr == null) {
            return false;
        }
        Listbox box = this.getListbox();
        if (box == null) {
            return false;
        }
        Scopes.beforeInterpret((Scope)this);
        try {
            int activePg;
            ListModel model = box.getModel();
            boolean isPagingMold = box.inPagingMold();
            int n = activePg = isPagingMold ? box.getPaginal().getActivePage() : 0;
            if (model != null) {
                if (model instanceof GroupsListModel) {
                    ((GroupsListModel)model).sort(cmpr, ascending, box.getListhead().getChildren().indexOf(this));
                } else {
                    if (!(model instanceof ListModelExt)) {
                        throw new UiException("ListModelExt must be implemented in " + model.getClass().getName());
                    }
                    ((ListModelExt)((Object)model)).sort(cmpr, ascending);
                }
            } else {
                Listheader.sort0(box, cmpr);
            }
            if (isPagingMold) {
                box.getPaginal().setActivePage(activePg);
            }
        }
        finally {
            Scopes.afterInterpret();
        }
        Iterator it = box.getListhead().getChildren().iterator();
        while (it.hasNext()) {
            Listheader hd;
            hd.setSortDirection((hd = (Listheader)it.next()) != this ? "natural" : (ascending ? "ascending" : "descending"));
        }
        box.invalidate();
        return true;
    }

    private static void sort0(Listbox box, Comparator cmpr) {
        if (box.hasGroup()) {
            Iterator it = box.getGroups().iterator();
            while (it.hasNext()) {
                Listgroup g = (Listgroup)it.next();
                Components.sort((List)box.getItems(), (int)(g.getIndex() + 1), (int)(g.getIndex() + 1 + g.getItemCount()), (Comparator)cmpr);
            }
        } else {
            Components.sort((List)box.getItems(), (Comparator)cmpr);
        }
    }

    public boolean sort(boolean ascending, boolean force) {
        if (force) {
            this.setSortDirection("natural");
        }
        return this.sort(ascending);
    }

    public void onSort() {
        String dir = this.getSortDirection();
        if ("ascending".equals(dir)) {
            this.sort(false);
        } else if ("descending".equals(dir)) {
            this.sort(true);
        } else if (!this.sort(true)) {
            this.sort(false);
        }
    }

    public String getZclass() {
        return this._zclass == null ? "z-listheader" : this._zclass;
    }

    public void beforeParentChanged(Component parent) {
        if (parent != null && !(parent instanceof Listhead)) {
            throw new UiException("Wrong parent: " + parent);
        }
        super.beforeParentChanged(parent);
    }

    protected void renderProperties(ContentRenderer renderer) throws IOException {
        super.renderProperties(renderer);
        if (!"none".equals(this._sortDscNm)) {
            this.render(renderer, "sortDescending", this._sortDscNm);
        }
        if (!"none".equals(this._sortAscNm)) {
            this.render(renderer, "sortAscending", this._sortAscNm);
        }
        if (!"natural".equals(this._sortDir)) {
            this.render(renderer, "sortDirection", this._sortDir);
        }
    }

    public Object clone() {
        Listheader clone = (Listheader)super.clone();
        clone.fixClone();
        return clone;
    }

    private void fixClone() {
        ListitemComparator c;
        if (this._sortAsc instanceof ListitemComparator && (c = (ListitemComparator)this._sortAsc).getListheader() == this && c.isAscending()) {
            this._sortAsc = new ListitemComparator(this, true, c.shallIgnoreCase());
        }
        if (this._sortDsc instanceof ListitemComparator && (c = (ListitemComparator)this._sortDsc).getListheader() == this && !c.isAscending()) {
            this._sortDsc = new ListitemComparator(this, false, c.shallIgnoreCase());
        }
    }

    private synchronized void writeObject(ObjectOutputStream s) throws IOException {
        ListitemComparator c;
        s.defaultWriteObject();
        boolean written = false;
        if (this._sortAsc instanceof ListitemComparator && (c = (ListitemComparator)this._sortAsc).getListheader() == this && c.isAscending()) {
            s.writeBoolean(true);
            s.writeBoolean(c.shallIgnoreCase());
            s.writeBoolean(c.byValue());
            written = true;
        }
        if (!written) {
            s.writeBoolean(false);
            s.writeObject(this._sortAsc);
        }
        written = false;
        if (this._sortDsc instanceof ListitemComparator && (c = (ListitemComparator)this._sortDsc).getListheader() == this && !c.isAscending()) {
            s.writeBoolean(true);
            s.writeBoolean(c.shallIgnoreCase());
            s.writeBoolean(c.byValue());
            written = true;
        }
        if (!written) {
            s.writeBoolean(false);
            s.writeObject(this._sortDsc);
        }
    }

    private synchronized void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        boolean byval;
        boolean igcs;
        s.defaultReadObject();
        boolean b = s.readBoolean();
        if (b) {
            igcs = s.readBoolean();
            byval = s.readBoolean();
            this._sortAsc = new ListitemComparator(this, true, igcs, byval);
        } else {
            this._sortAsc = (Comparator)s.readObject();
        }
        b = s.readBoolean();
        if (b) {
            igcs = s.readBoolean();
            byval = s.readBoolean();
            this._sortDsc = new ListitemComparator(this, false, igcs, byval);
        } else {
            this._sortDsc = (Comparator)s.readObject();
        }
    }

    static {
        Listheader.addClientEvent((Class)Listheader.class, (String)"onSort", (int)8192);
    }
}

