/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.zkoss.lang.Classes;
import org.zkoss.lang.Objects;
import org.zkoss.lang.Strings;
import org.zkoss.mesg.Messages;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Components;
import org.zkoss.zk.ui.Page;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.WrongValueException;
import org.zkoss.zk.ui.ext.Scope;
import org.zkoss.zk.ui.ext.Scopes;
import org.zkoss.zk.ui.sys.ContentRenderer;
import org.zkoss.zul.Columns;
import org.zkoss.zul.FieldComparator;
import org.zkoss.zul.Grid;
import org.zkoss.zul.Group;
import org.zkoss.zul.GroupComparator;
import org.zkoss.zul.GroupsListModel;
import org.zkoss.zul.Label;
import org.zkoss.zul.ListModel;
import org.zkoss.zul.ListModelExt;
import org.zkoss.zul.Row;
import org.zkoss.zul.RowComparator;
import org.zkoss.zul.Rows;
import org.zkoss.zul.impl.HeaderElement;
import org.zkoss.zul.mesg.MZul;

public class Column
extends HeaderElement
implements org.zkoss.zul.api.Column {
    private String _sortDir = "natural";
    private transient Comparator _sortAsc;
    private transient Comparator _sortDsc;
    private String _sortAscNm = "none";
    private String _sortDscNm = "none";
    private Object _value;

    public Column() {
    }

    public Column(String label) {
        super(label);
    }

    public Column(String label, String src) {
        super(label, src);
    }

    public Column(String label, String src, String width) {
        super(label, src);
        this.setWidth(width);
    }

    public Grid getGrid() {
        Component parent = this.getParent();
        return parent != null ? (Grid)parent.getParent() : null;
    }

    public org.zkoss.zul.api.Grid getGridApi() {
        return this.getGrid();
    }

    public String getSortDirection() {
        return this._sortDir;
    }

    public void setSortDirection(String sortDir) throws WrongValueException {
        if (sortDir == null || !"ascending".equals(sortDir) && !"descending".equals(sortDir) && !"natural".equals(sortDir)) {
            throw new WrongValueException("Unknown sort direction: " + sortDir);
        }
        if (!Objects.equals((Object)this._sortDir, (Object)sortDir)) {
            this._sortDir = sortDir;
            this.smartUpdate("sortDirection", this._sortDir);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setSort(String type) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        if (type == null) {
            return;
        }
        if (type.startsWith("client")) {
            this.setSortAscending(type);
            this.setSortDescending(type);
            return;
        } else if ("auto".equals(type)) {
            if (this.getSortAscending() == null) {
                this.setSortAscending(new RowComparator(this, true, false, false));
            }
            if (this.getSortDescending() != null) return;
            this.setSortDescending(new RowComparator(this, false, false, false));
            return;
        } else if (type.startsWith("auto")) {
            int j = type.indexOf(40);
            int k = type.lastIndexOf(41);
            if (j < 0 || k < 0) throw new UiException("Unknown sort type: " + type);
            String fieldnames = type.substring(j + 1, k);
            if (this.getSortAscending() == null) {
                this.setSortAscending(new FieldComparator(fieldnames, true));
            }
            if (this.getSortDescending() != null) return;
            this.setSortDescending(new FieldComparator(fieldnames, false));
            return;
        } else {
            if (!"none".equals(type)) return;
            this.setSortAscending((Comparator)null);
            this.setSortDescending((Comparator)null);
        }
    }

    public Comparator getSortAscending() {
        return this._sortAsc;
    }

    public void setSortAscending(Comparator sorter) {
        if (!Objects.equals((Object)this._sortAsc, (Object)sorter)) {
            String nm;
            this._sortAsc = sorter;
            String string = nm = this._sortAsc == null ? "none" : "fromServer";
            if (!this._sortAscNm.equals(nm)) {
                this._sortAscNm = nm;
                this.smartUpdate("sortAscending", this._sortAscNm);
            }
        }
    }

    public void setSortAscending(String clsnm) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        if (!Strings.isBlank((String)clsnm) && clsnm.startsWith("client") && !this._sortAscNm.equals(clsnm)) {
            this._sortAscNm = clsnm;
            this.smartUpdate("sortAscending", clsnm);
        } else {
            this.setSortAscending(this.toComparator(clsnm));
        }
    }

    public Comparator getSortDescending() {
        return this._sortDsc;
    }

    public void setSortDescending(Comparator sorter) {
        if (!Objects.equals((Object)this._sortDsc, (Object)sorter)) {
            String nm;
            this._sortDsc = sorter;
            String string = nm = this._sortDsc == null ? "none" : "fromServer";
            if (!this._sortDscNm.equals(nm)) {
                this._sortDscNm = nm;
                this.smartUpdate("sortDescending", this._sortDscNm);
            }
        }
    }

    public void setSortDescending(String clsnm) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        if (!Strings.isBlank((String)clsnm) && clsnm.startsWith("client") && !this._sortDscNm.equals(clsnm)) {
            this._sortDscNm = clsnm;
            this.smartUpdate("sortDescending", clsnm);
        } else {
            this.setSortDescending(this.toComparator(clsnm));
        }
    }

    private Comparator toComparator(String clsnm) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        Class cls;
        if (clsnm == null || clsnm.length() == 0) {
            return null;
        }
        Page page = this.getPage();
        Class clazz = cls = page != null ? page.getZScriptClass(clsnm) : Classes.forNameByThread((String)clsnm);
        if (cls == null) {
            throw new ClassNotFoundException(clsnm);
        }
        if (!Comparator.class.isAssignableFrom(cls)) {
            throw new UiException("Comparator must be implemented: " + clsnm);
        }
        return (Comparator)cls.newInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean sort(boolean ascending) {
        Comparator cmpr;
        String dir = this.getSortDirection();
        if (ascending ? "ascending".equals(dir) : "descending".equals(dir)) {
            return false;
        }
        Comparator comparator = cmpr = ascending ? this._sortAsc : this._sortDsc;
        if (cmpr == null) {
            return false;
        }
        Grid grid = this.getGrid();
        Rows rows = grid.getRows();
        if (grid == null || rows == null) {
            return false;
        }
        Scopes.beforeInterpret((Scope)this);
        try {
            int activePg;
            ListModel model = grid.getModel();
            boolean isPagingMold = grid.inPagingMold();
            int n = activePg = isPagingMold ? grid.getPaginal().getActivePage() : 0;
            if (model != null) {
                if (model instanceof GroupsListModel) {
                    ((GroupsListModel)model).sort(cmpr, ascending, grid.getColumns().getChildren().indexOf(this));
                } else {
                    if (!(model instanceof ListModelExt)) {
                        throw new UiException("ListModelExt must be implemented in " + model.getClass());
                    }
                    ((ListModelExt)((Object)model)).sort(cmpr, ascending);
                }
            } else {
                Column.sort0(grid, cmpr);
            }
            if (isPagingMold) {
                grid.getPaginal().setActivePage(activePg);
            }
        }
        finally {
            Scopes.afterInterpret();
        }
        this.fixDirection(grid, ascending);
        grid.getRows().invalidate();
        return true;
    }

    private static void sort0(Grid grid, Comparator cmpr) {
        Rows rows = grid.getRows();
        if (rows.hasGroup()) {
            Iterator it = rows.getGroups().iterator();
            while (it.hasNext()) {
                Group g = (Group)it.next();
                int index = g.getIndex() + 1;
                Components.sort((List)rows.getChildren(), (int)index, (int)(index + g.getItemCount()), (Comparator)cmpr);
            }
        } else {
            Components.sort((List)rows.getChildren(), (Comparator)cmpr);
        }
    }

    private void fixDirection(Grid grid, boolean ascending) {
        Iterator it = grid.getColumns().getChildren().iterator();
        while (it.hasNext()) {
            Column hd;
            hd.setSortDirection((hd = (Column)it.next()) != this ? "natural" : (ascending ? "ascending" : "descending"));
        }
    }

    public boolean sort(boolean ascending, boolean force) {
        if (force) {
            this.setSortDirection("natural");
        }
        return this.sort(ascending);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean group(boolean ascending) {
        Comparator cmpr;
        String dir = this.getSortDirection();
        if (ascending ? "ascending".equals(dir) : "descending".equals(dir)) {
            return false;
        }
        Comparator comparator = cmpr = ascending ? this._sortAsc : this._sortDsc;
        if (cmpr == null) {
            return false;
        }
        Grid grid = this.getGrid();
        if (grid == null) {
            return false;
        }
        Scopes.beforeInterpret((Scope)this);
        try {
            ListModel model = grid.getModel();
            int index = grid.getColumns().getChildren().indexOf(this);
            if (model != null) {
                if (!(model instanceof GroupsListModel)) {
                    throw new UiException("GroupsModel must be implemented in " + model.getClass().getName());
                }
                ((GroupsListModel)model).group(cmpr, ascending, index);
            } else {
                Rows rows = grid.getRows();
                if (rows == null) {
                    boolean bl = false;
                    return bl;
                }
                if (rows.hasGroup()) {
                    ArrayList groups = new ArrayList(rows.getGroups());
                    Iterator it = groups.iterator();
                    while (it.hasNext()) {
                        ((Group)it.next()).detach();
                    }
                }
                Comparator cmprx = cmpr instanceof GroupComparator ? new Comparator(){

                    public int compare(Object o1, Object o2) {
                        return ((GroupComparator)cmpr).compareGroup(o1, o2);
                    }
                } : cmpr;
                LinkedList children = new LinkedList(rows.getChildren());
                rows.getChildren().clear();
                Collections.sort(children, cmprx);
                Row previous = null;
                Iterator it = children.iterator();
                while (it.hasNext()) {
                    Row row = (Row)it.next();
                    it.remove();
                    if (previous == null || cmprx.compare(previous, row) != 0) {
                        Group group;
                        List cells = row.getChildren();
                        if (cells.size() < index) {
                            throw new IndexOutOfBoundsException("Index: " + index + " but size: " + cells.size());
                        }
                        Component cell = (Component)cells.get(index);
                        if (cell instanceof Label) {
                            String val = ((Label)cell).getValue();
                            group = new Group(val);
                        } else {
                            Component cc = cell.getFirstChild();
                            if (cc instanceof Label) {
                                String val = ((Label)cc).getValue();
                                group = new Group(val);
                            } else {
                                group = new Group(Messages.get((int)MZul.GRID_OTHER));
                            }
                        }
                        rows.appendChild((Component)group);
                    }
                    rows.appendChild((Component)row);
                    previous = row;
                }
                if (cmprx != cmpr) {
                    Column.sort0(grid, cmpr);
                }
            }
        }
        finally {
            Scopes.afterInterpret();
        }
        this.fixDirection(grid, ascending);
        grid.getRows().invalidate();
        return true;
    }

    protected void renderProperties(ContentRenderer renderer) throws IOException {
        super.renderProperties(renderer);
        if (!"none".equals(this._sortDscNm)) {
            this.render(renderer, "sortDescending", this._sortDscNm);
        }
        if (!"none".equals(this._sortAscNm)) {
            this.render(renderer, "sortAscending", this._sortAscNm);
        }
        if (!"natural".equals(this._sortDir)) {
            this.render(renderer, "sortDirection", this._sortDir);
        }
    }

    public Object getValue() {
        return this._value;
    }

    public void setValue(Object value) {
        this._value = value;
    }

    public void onSort() {
        String dir = this.getSortDirection();
        if ("ascending".equals(dir)) {
            this.sort(false);
        } else if ("descending".equals(dir)) {
            this.sort(true);
        } else if (!this.sort(true)) {
            this.sort(false);
        }
    }

    public void onGroup() {
        String dir = this.getSortDirection();
        if ("ascending".equals(dir)) {
            this.group(false);
        } else if ("descending".equals(dir)) {
            this.group(true);
        } else if (!this.group(true)) {
            this.group(false);
        }
    }

    public String getZclass() {
        return this._zclass == null ? "z-column" : this._zclass;
    }

    public void beforeParentChanged(Component parent) {
        if (parent != null && !(parent instanceof Columns)) {
            throw new UiException("Unsupported parent for column: " + parent);
        }
        super.beforeParentChanged(parent);
    }

    public Object clone() {
        Column clone = (Column)super.clone();
        clone.fixClone();
        return clone;
    }

    private void fixClone() {
        RowComparator c;
        if (this._sortAsc instanceof RowComparator && (c = (RowComparator)this._sortAsc).getColumn() == this && c.isAscending()) {
            this._sortAsc = new RowComparator(this, true, c.shallIgnoreCase(), false);
        }
        if (this._sortDsc instanceof RowComparator && (c = (RowComparator)this._sortDsc).getColumn() == this && !c.isAscending()) {
            this._sortDsc = new RowComparator(this, false, c.shallIgnoreCase(), false);
        }
    }

    private synchronized void writeObject(ObjectOutputStream s) throws IOException {
        RowComparator c;
        s.defaultWriteObject();
        boolean written = false;
        if (this._sortAsc instanceof RowComparator && (c = (RowComparator)this._sortAsc).getColumn() == this && c.isAscending()) {
            s.writeBoolean(true);
            s.writeBoolean(c.shallIgnoreCase());
            written = true;
        }
        if (!written) {
            s.writeBoolean(false);
            s.writeObject(this._sortAsc);
        }
        written = false;
        if (this._sortDsc instanceof RowComparator && (c = (RowComparator)this._sortDsc).getColumn() == this && !c.isAscending()) {
            s.writeBoolean(true);
            s.writeBoolean(c.shallIgnoreCase());
            written = true;
        }
        if (!written) {
            s.writeBoolean(false);
            s.writeObject(this._sortDsc);
        }
    }

    private synchronized void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        boolean igcs;
        s.defaultReadObject();
        boolean b = s.readBoolean();
        if (b) {
            igcs = s.readBoolean();
            this._sortAsc = new RowComparator(this, true, igcs, false);
        } else {
            this._sortAsc = (Comparator)s.readObject();
        }
        b = s.readBoolean();
        if (b) {
            igcs = s.readBoolean();
            this._sortDsc = new RowComparator(this, false, igcs, false);
        } else {
            this._sortDsc = (Comparator)s.readObject();
        }
    }

    static {
        Column.addClientEvent((Class)Column.class, (String)"onSort", (int)8192);
        Column.addClientEvent((Class)Column.class, (String)"onGroup", (int)8192);
    }
}

