/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul;

import java.util.Iterator;
import org.zkoss.lang.Objects;
import org.zkoss.xml.HTMLs;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.WrongValueException;
import org.zkoss.zul.Tab;
import org.zkoss.zul.api.Tabbox;
import org.zkoss.zul.impl.XulElement;

public class Tabs
extends XulElement
implements org.zkoss.zul.api.Tabs {
    private String _align = "start";

    public org.zkoss.zul.Tabbox getTabbox() {
        return (org.zkoss.zul.Tabbox)this.getParent();
    }

    public Tabbox getTabboxApi() {
        return this.getTabbox();
    }

    public String getWidth() {
        String width = super.getWidth();
        if (this.getTabbox().isVertical() && width == null) {
            width = "50px";
        }
        return width;
    }

    public String getAlign() {
        return this._align;
    }

    public void setAlign(String align) throws WrongValueException {
        if (!("start".equals(align) || "center".equals(align) || "end".equals(align))) {
            throw new WrongValueException(align);
        }
        if (!Objects.equals((Object)this._align, (Object)align)) {
            this._align = align;
            org.zkoss.zul.Tabbox tabbox = this.getTabbox();
            if (!tabbox.inAccordionMold()) {
                this.invalidate();
            }
        }
    }

    protected String getRealSclass() {
        String scls = super.getRealSclass();
        org.zkoss.zul.Tabbox tabbox = this.getTabbox();
        String added = tabbox != null && tabbox.isTabscroll() ? this.getZclass() + "-scroll" : "";
        return scls != null && scls.length() > 0 ? scls + " " + added : added;
    }

    public String getZclass() {
        if (this._zclass != null) {
            return this._zclass;
        }
        org.zkoss.zul.Tabbox tabbox = this.getTabbox();
        String added = tabbox != null && tabbox.isVertical() ? "-ver" : "";
        return "z-tabs" + added;
    }

    public void beforeParentChanged(Component parent) {
        if (parent != null && !(parent instanceof org.zkoss.zul.Tabbox)) {
            throw new UiException("Wrong parent: " + parent);
        }
        super.beforeParentChanged(parent);
    }

    public void setParent(Component parent) {
        org.zkoss.zul.Tabbox oldp = (org.zkoss.zul.Tabbox)this.getParent();
        super.setParent(parent);
        Tabs.invalidateIfAccordion(oldp);
        Tabs.invalidateIfAccordion((org.zkoss.zul.Tabbox)parent);
    }

    public void beforeChildAdded(Component child, Component refChild) {
        if (!(child instanceof Tab)) {
            throw new UiException("Unsupported child for tabs: " + child);
        }
        super.beforeChildAdded(child, refChild);
    }

    public boolean insertBefore(Component child, Component refChild) {
        boolean sel = this.getChildren().isEmpty();
        boolean desel = false;
        if (sel) {
            this.invalidate();
        }
        Tab newtab = (Tab)child;
        if (!sel && newtab.isSelected()) {
            newtab.setSelectedDirectly(false);
            desel = true;
            sel = true;
        }
        if (super.insertBefore(child, refChild)) {
            org.zkoss.zul.Tabbox tabbox = this.getTabbox();
            if (sel) {
                if (tabbox != null) {
                    tabbox.setSelectedTab(newtab);
                } else {
                    newtab.setSelectedDirectly(true);
                    if (desel) {
                        Iterator it = this.getChildren().iterator();
                        while (it.hasNext()) {
                            Tab tab = (Tab)it.next();
                            if (tab == newtab || !tab.isSelected()) continue;
                            tab.setSelectedDirectly(false);
                            break;
                        }
                    }
                }
            }
            Tabs.invalidateIfAccordion(tabbox);
            return true;
        }
        return false;
    }

    public void onChildRemoved(Component child) {
        super.onChildRemoved(child);
        org.zkoss.zul.Tabbox tabbox = this.getTabbox();
        if (tabbox != null) {
            ((Tab)child).removeEventListener("onSelect", tabbox._listener);
        }
    }

    public void onChildAdded(Component child) {
        super.onChildAdded(child);
        org.zkoss.zul.Tabbox tabbox = this.getTabbox();
        if (tabbox != null) {
            ((Tab)child).addEventListener("onSelect", tabbox._listener);
        }
        if (tabbox == null || !tabbox.inAccordionMold()) {
            this.smartUpdate("z.initscroll", true);
        }
    }

    public void invalidate() {
        org.zkoss.zul.Tabbox tabbox = this.getTabbox();
        if (tabbox != null && tabbox.isVertical()) {
            tabbox.invalidate();
        } else {
            super.invalidate();
        }
    }

    private static void invalidateIfAccordion(org.zkoss.zul.Tabbox tabbox) {
        if (tabbox != null && tabbox.inAccordionMold()) {
            tabbox.invalidate();
        }
    }

    public String getOuterAttrs() {
        org.zkoss.zul.Tabbox tabbox = this.getTabbox();
        if (!tabbox.inAccordionMold()) {
            StringBuffer sb = new StringBuffer(64).append(super.getOuterAttrs());
            if (!"start".equals(this._align)) {
                HTMLs.appendAttribute((StringBuffer)sb, (String)"z.align", (String)this._align.substring(0, 1));
            }
            return sb.toString();
        }
        return super.getOuterAttrs();
    }
}

