/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul;

import java.io.IOException;
import java.io.Writer;
import org.zkoss.lang.Objects;
import org.zkoss.util.media.AMedia;
import org.zkoss.util.media.Media;
import org.zkoss.xml.HTMLs;
import org.zkoss.zk.ui.AbstractComponent;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.ext.render.DynamicMedia;
import org.zkoss.zul.impl.Utils;

public class Style
extends AbstractComponent
implements org.zkoss.zul.api.Style {
    private String _src;
    private String _content;
    private boolean _dynamic;
    private byte _cntver;

    public Style() {
        super.setVisible(false);
    }

    public Style(String src) {
        this();
        this.setSrc(src);
    }

    public void setDynamic(boolean dynamic) {
        if (this._dynamic != dynamic) {
            this._dynamic = dynamic;
            this.invalidate();
        }
    }

    public boolean isDynamic() {
        return this._dynamic;
    }

    public String getSrc() {
        return this._src;
    }

    public void setSrc(String src) {
        if (src != null && src.length() == 0) {
            src = null;
        }
        if (this._content != null || !Objects.equals((Object)this._src, (Object)src)) {
            this._src = src;
            this._content = null;
            this.invalidate();
        }
    }

    public String getContent() {
        return this._content;
    }

    public void setContent(String content) {
        if (content != null && content.length() == 0) {
            content = null;
        }
        if (this._src != null || !Objects.equals((Object)this._content, (Object)content)) {
            this._content = content;
            this._src = null;
            this._cntver = (byte)(this._cntver + 1);
            this.invalidate();
        }
    }

    public String getOuterAttrs() {
        StringBuffer sb = new StringBuffer(64);
        HTMLs.appendAttribute((StringBuffer)sb, (String)"z.src", (String)(this._src != null ? this.getDesktop().getExecution().encodeURL(this._src) : Utils.getDynamicMediaURI(this, this._cntver, "css", "css")));
        return sb.toString();
    }

    public boolean setVisible(boolean visible) {
        throw new UnsupportedOperationException("style is always invisible");
    }

    public boolean isChildable() {
        return false;
    }

    protected Object newExtraCtrl() {
        return new ExtraCtrl();
    }

    public void redraw(Writer out) throws IOException {
        if (this.isDynamic()) {
            super.redraw(out);
            return;
        }
        boolean ie = Executions.getCurrent().isExplorer();
        if (ie) {
            out.write("<div id=\"");
            out.write(this.getUuid());
            out.write("\">");
        }
        if (this._src != null) {
            out.write("\n<link rel=\"stylesheet\" type=\"text/css\" href=\"");
            out.write(this.getDesktop().getExecution().encodeURL(this._src));
            if (!ie) {
                out.write("\" id=\"");
                out.write(this.getUuid());
            }
            out.write("\"/>");
        } else {
            out.write("\n<style type=\"text/css\"");
            if (!ie) {
                out.write(" id=\"");
                out.write(this.getUuid());
                out.write(34);
            }
            out.write(">\n");
            String content = this.getContent();
            if (content != null) {
                out.write(content);
                out.write(10);
            }
            out.write("</style>");
        }
        if (ie) {
            out.write("</div>\n");
        }
    }

    protected class ExtraCtrl
    implements DynamicMedia {
        protected ExtraCtrl() {
        }

        public Media getMedia(String pathInfo) {
            return new AMedia("css", "css", "text/css;charset=UTF-8", Style.this._content);
        }
    }
}

