/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul;

import org.zkoss.lang.Objects;
import org.zkoss.xml.HTMLs;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.WrongValueException;
import org.zkoss.zk.ui.ext.client.Scrollable;
import org.zkoss.zul.impl.XulElement;

public class Slider
extends XulElement
implements org.zkoss.zul.api.Slider {
    private String _orient = "horizontal";
    private int _curpos;
    private int _maxpos = 100;
    private int _pginc = 10;
    private String _name;
    private String _slidingtext = "{0}";

    public Slider() {
        this.setWidth("207px");
    }

    public Slider(int curpos) {
        this();
        this.setCurpos(curpos);
    }

    final boolean inScaleMold() {
        return "scale".equals(this.getMold());
    }

    final boolean inSphereMold() {
        return "sphere".equals(this.getMold());
    }

    public String getZclass() {
        String name = "z-slider";
        if (this._zclass == null) {
            if (this.inScaleMold()) {
                return "z-slider-scale";
            }
            if (this.inSphereMold()) {
                return "z-slider" + ("horizontal".equals(this.getOrient()) ? "-sphere-hor" : "-sphere-ver");
            }
            return "z-slider" + ("horizontal".equals(this.getOrient()) ? "-hor" : "-ver");
        }
        return this._zclass;
    }

    public String getOrient() {
        return this._orient;
    }

    public void setOrient(String orient) throws WrongValueException {
        if (!"horizontal".equals(orient) && !"vertical".equals(orient)) {
            throw new WrongValueException("orient cannot be " + orient);
        }
        if (!Objects.equals((Object)this._orient, (Object)orient)) {
            this._orient = orient;
            if ("vertical".equals(this._orient)) {
                this.setWidth(null);
                this.setHeight("207px");
            } else {
                this.setWidth("207px");
                this.setHeight(null);
            }
            this.invalidate();
        }
    }

    public String getSlidingtext() {
        return this._slidingtext;
    }

    public void setSlidingtext(String slidingtext) {
        if (slidingtext == null || slidingtext.length() == 0) {
            slidingtext = "{0}";
        }
        if (!this._slidingtext.equals(slidingtext)) {
            this._slidingtext = slidingtext;
            this.smartUpdate("z.slidingtext", this._slidingtext);
        }
    }

    public final int getCurpos() {
        return this._curpos;
    }

    public final void setCurpos(int curpos) throws WrongValueException {
        if (curpos < 0) {
            curpos = 0;
        } else if (curpos > this._maxpos) {
            curpos = this._maxpos;
        }
        if (this._curpos != curpos) {
            this._curpos = curpos;
            this.smartUpdate("z.curpos", this._curpos);
        }
    }

    public final int getMaxpos() {
        return this._maxpos;
    }

    public final void setMaxpos(int maxpos) throws WrongValueException {
        if (maxpos <= 0) {
            throw new WrongValueException("Nonpositive is not allowed: " + maxpos);
        }
        if (this._maxpos != maxpos) {
            if (this._curpos > maxpos) {
                this.setCurpos(maxpos);
            }
            this._maxpos = maxpos;
            this.smartUpdate("z.maxpos", this._maxpos);
        }
    }

    public boolean isVertical() {
        return "vertical".equals(this.getOrient());
    }

    public final int getPageIncrement() {
        return this._pginc;
    }

    public final void setPageIncrement(int pginc) throws WrongValueException {
        if (pginc <= 0) {
            throw new WrongValueException("Nonpositive is not allowed: " + pginc);
        }
        if (this._pginc != pginc) {
            this._pginc = pginc;
            this.smartUpdate("z.pginc", this._pginc);
        }
    }

    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        if (name != null && name.length() == 0) {
            name = null;
        }
        if (!Objects.equals((Object)this._name, (Object)name)) {
            this._name = name;
            this.smartUpdate("z.name", this._name);
        }
    }

    public void setMold(String mold) {
        if (this.isVertical()) {
            if (mold.startsWith("scale")) {
                throw new WrongValueException("Unsupported vertical orient in mold : " + mold);
            }
            super.setMold(mold);
        } else {
            super.setMold(mold);
        }
    }

    public String getOuterAttrs() {
        StringBuffer sb = new StringBuffer(64).append(super.getOuterAttrs());
        if ("vertical".equals(this.getOrient())) {
            HTMLs.appendAttribute((StringBuffer)sb, (String)"z.vert", (String)"true");
        }
        HTMLs.appendAttribute((StringBuffer)sb, (String)"z.name", (String)this._name);
        HTMLs.appendAttribute((StringBuffer)sb, (String)"z.curpos", (int)this._curpos);
        HTMLs.appendAttribute((StringBuffer)sb, (String)"z.maxpos", (int)this._maxpos);
        HTMLs.appendAttribute((StringBuffer)sb, (String)"z.pginc", (int)this._pginc);
        HTMLs.appendAttribute((StringBuffer)sb, (String)"z.slidingtext", (String)this.getSlidingtext());
        this.appendAsapAttr(sb, "onScroll");
        this.appendAsapAttr(sb, "onScrolling");
        this.appendAsapAttr(sb, "onRightClick");
        return sb.toString();
    }

    public boolean isChildable() {
        return false;
    }

    protected Object newExtraCtrl() {
        return new ExtraCtrl();
    }

    protected class ExtraCtrl
    extends HtmlBasedComponent.ExtraCtrl
    implements Scrollable {
        protected ExtraCtrl() {
            super((HtmlBasedComponent)Slider.this);
        }

        public final void setCurposByClient(int curpos) {
            if (curpos < 0) {
                throw new WrongValueException("Negative is not allowed: " + curpos);
            }
            Slider.this._curpos = curpos;
        }
    }
}

