/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul;

import org.zkoss.lang.Library;
import org.zkoss.lang.Objects;
import org.zkoss.zk.ui.Execution;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.WrongValueException;
import org.zkoss.zul.impl.XulElement;

public class Separator
extends XulElement
implements org.zkoss.zul.api.Separator {
    private String _orient = "horizontal";
    private String _spacing;
    private boolean _bar;
    private static Boolean _spmargin;

    public Separator() {
    }

    public Separator(String orient) {
        this.setOrient(orient);
    }

    public String getOrient() {
        return this._orient;
    }

    public void setOrient(String orient) throws WrongValueException {
        if (!"horizontal".equals(orient) && !"vertical".equals(orient)) {
            throw new WrongValueException(orient);
        }
        if (!Objects.equals((Object)this._orient, (Object)orient)) {
            this._orient = orient;
            this.invalidate();
        }
    }

    public boolean isHorizontal() {
        return "horizontal".equals(this.getOrient());
    }

    public boolean isVertical() {
        return "vertical".equals(this.getOrient());
    }

    public boolean isBar() {
        return this._bar;
    }

    public void setBar(boolean bar) {
        if (this._bar != bar) {
            this._bar = bar;
            this.smartUpdate("class", this.getZclass());
        }
    }

    public String getSpacing() {
        return this._spacing;
    }

    public void setSpacing(String spacing) {
        if (spacing != null) {
            spacing = spacing.length() == 0 ? null : spacing.trim();
        }
        if (!Objects.equals((Object)this._spacing, (Object)spacing)) {
            this._spacing = spacing;
            this.smartUpdate("style", this.getRealStyle());
        }
    }

    public String getWidth() {
        String wd = super.getWidth();
        return this.isHorizontal() || wd != null && wd.length() > 0 || this.isPercentInFF() || this.isSpaceWithMargin() ? wd : this._spacing;
    }

    public String getHeight() {
        String hgh = super.getHeight();
        return this.isVertical() || hgh != null && hgh.length() > 0 || this.isPercentInFF() || this.isSpaceWithMargin() ? hgh : this._spacing;
    }

    protected String getRealStyle() {
        String spacing;
        String style = super.getRealStyle();
        String string = spacing = this.isSpaceWithMargin() ? this._spacing : this.splitPercentInFF();
        if (spacing == null) {
            return style;
        }
        StringBuffer sb = new StringBuffer(64).append("margin:");
        if (this.isVertical()) {
            sb.append("0 ").append(spacing);
        } else {
            sb.append(spacing).append(" 0");
        }
        return sb.append(';').append(style).toString();
    }

    private boolean isPercentInFF() {
        if (this._spacing != null && this._spacing.endsWith("%")) {
            Execution exec = Executions.getCurrent();
            return exec != null && exec.isGecko();
        }
        return false;
    }

    private String splitPercentInFF() {
        if (this.isPercentInFF()) {
            try {
                int v = Integer.parseInt(this._spacing.substring(0, this._spacing.length() - 1).trim());
                if (v > 0) {
                    return v > 1 ? v / 2 + "%" : "1%";
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return null;
    }

    public String getZclass() {
        return this._zclass == null ? "z-separator" + (this.isVertical() ? "-ver" + (this.isBar() ? "-bar" : "") : "-hor" + (this.isBar() ? "-bar" : "")) : this._zclass;
    }

    public boolean isSpaceWithMargin() {
        if (_spmargin == null) {
            String s = Library.getProperty((String)"org.zkoss.zul.Separator.spaceWithMargin");
            _spmargin = s != null && s.length() > 0;
        }
        return _spmargin;
    }

    public boolean isChildable() {
        return false;
    }
}

