/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Iterator;
import java.util.List;
import org.zkoss.lang.JVMs;
import org.zkoss.lang.Objects;
import org.zkoss.xml.HTMLs;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.WrongValueException;
import org.zkoss.zul.Column;
import org.zkoss.zul.Columns;
import org.zkoss.zul.Grid;
import org.zkoss.zul.Group;
import org.zkoss.zul.Groupfoot;
import org.zkoss.zul.Rows;
import org.zkoss.zul.api.Detail;
import org.zkoss.zul.impl.Utils;
import org.zkoss.zul.impl.XulElement;

public class Row
extends XulElement
implements org.zkoss.zul.api.Row {
    private Object _value;
    private String _align;
    private String _valign;
    private int[] _spans;
    private transient int _rsflags;
    private boolean _nowrap;
    private boolean _loaded;
    private transient org.zkoss.zul.Detail _detail;

    public org.zkoss.zul.Detail getDetailChild() {
        return this._detail;
    }

    public Detail getDetailChildApi() {
        return this.getDetailChild();
    }

    public Grid getGrid() {
        Component parent = this.getParent();
        return parent != null ? (Grid)parent.getParent() : null;
    }

    public org.zkoss.zul.api.Grid getGridApi() {
        return this.getGrid();
    }

    public String getAlign() {
        return this._align;
    }

    public void setAlign(String align) {
        if (!Objects.equals((Object)this._align, (Object)align)) {
            this._align = align;
            this.smartUpdate("align", this._align);
        }
    }

    public boolean isNowrap() {
        return this._nowrap;
    }

    public void setNowrap(boolean nowrap) {
        if (this._nowrap != nowrap) {
            this._nowrap = nowrap;
            this.smartUpdate("nowrap", this._nowrap);
        }
    }

    public String getValign() {
        return this._valign;
    }

    public void setValign(String valign) {
        if (!Objects.equals((Object)this._valign, (Object)valign)) {
            this._valign = valign;
            this.smartUpdate("valign", this._valign);
        }
    }

    public boolean setVisible(boolean visible) {
        Group g;
        Rows rows;
        if (this.isVisible() != visible && (rows = (Rows)this.getParent()) != null && ((g = rows.getGroup(this.getIndex())) == null || g.isOpen())) {
            rows.addVisibleItemCount(visible ? 1 : -1);
        }
        return super.setVisible(visible);
    }

    public Object getValue() {
        return this._value;
    }

    public void setValue(Object value) {
        this._value = value;
    }

    public String getSpans() {
        return Utils.intsToString(this._spans);
    }

    public void setSpans(String spans) throws WrongValueException {
        int[] ispans = Utils.stringToInts(spans, 1);
        if (!Objects.equals((Object)ispans, (Object)this._spans)) {
            this._spans = ispans;
            this.invalidate();
        }
    }

    final void setLoaded(boolean loaded) {
        if (loaded != this._loaded) {
            this._loaded = loaded;
            Grid grid = this.getGrid();
            if (grid != null && grid.getModel() != null) {
                if (this._loaded && !grid.inPagingMold()) {
                    this.invalidate();
                } else {
                    this.smartUpdate("z.loaded", this._loaded);
                }
            }
        }
    }

    final boolean isLoaded() {
        return this._loaded;
    }

    int getIndex() {
        int j = 0;
        Iterator it = this.getParent().getChildren().iterator();
        while (it.hasNext() && it.next() != this) {
            ++j;
        }
        return j;
    }

    protected String getRealSclass() {
        String scls = super.getRealSclass();
        if (this instanceof Group || this instanceof Groupfoot || !this.isVisible()) {
            return scls;
        }
        String sclx = (String)this.getParent().getAttribute("org.zkoss.zul.StripeState");
        return scls + (sclx != null ? " " + sclx : "");
    }

    public String getZclass() {
        return this._zclass == null ? "z-row" : this._zclass;
    }

    protected String getRealStyle() {
        if (this instanceof Group || this instanceof Groupfoot || !this.isVisible()) {
            return super.getRealStyle();
        }
        Group g = this.getGroup();
        return super.getRealStyle() + (g != null && !g.isOpen() ? "display:none" : "");
    }

    public Group getGroup() {
        if (this instanceof Group) {
            return (Group)this;
        }
        Rows rows = (Rows)this.getParent();
        return rows != null ? rows.getGroup(this.getIndex()) : null;
    }

    public org.zkoss.zul.api.Group getGroupApi() {
        return this.getGroup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getChildAttrs(int index) {
        String clx;
        String style;
        List colchds;
        Columns cols;
        int realIndex = index;
        int span = 1;
        if (this._spans != null) {
            for (int j = 0; j < this._spans.length; ++j) {
                if (j == index) {
                    span = this._spans[j];
                    break;
                }
                realIndex += this._spans[j] - 1;
            }
        }
        String colattrs = null;
        String visible = null;
        String hgh = null;
        Grid grid = this.getGrid();
        if (grid != null && (cols = grid.getColumns()) != null && realIndex < (colchds = cols.getChildren()).size()) {
            Column col = (Column)colchds.get(realIndex);
            colattrs = col.getColAttrs();
            visible = col.isVisible() ? "" : "display:none";
            hgh = col.getHeight();
        }
        Component child = (Component)this.getChildren().get(index);
        this._rsflags = 7;
        try {
            String wd;
            style = super.getRealStyle();
            if (child instanceof org.zkoss.zul.Detail && (wd = ((org.zkoss.zul.Detail)child).getWidth()) != null) {
                style = style + "width:" + wd + ";";
            }
        }
        finally {
            this._rsflags = 0;
        }
        if (visible != null || hgh != null) {
            StringBuffer sb = new StringBuffer(80).append(style).append(visible);
            HTMLs.appendStyle((StringBuffer)sb, (String)"height", (String)hgh);
            style = sb.toString();
        }
        String string = clx = child instanceof org.zkoss.zul.Detail ? ((org.zkoss.zul.Detail)child).getZclass() + "-outer" : this.getZclass() + "-inner";
        if (colattrs == null && style.length() == 0 && span == 1) {
            return " class=\"" + clx + "\"";
        }
        StringBuffer sb = new StringBuffer(100);
        if (colattrs != null) {
            sb.append(colattrs);
        }
        if (span != 1) {
            sb.append(" colspan=\"").append(span).append('\"');
        }
        HTMLs.appendAttribute((StringBuffer)sb, (String)"style", (String)style);
        return sb.append(" class=\"").append(clx).append('\"').toString();
    }

    protected int getRealStyleFlags() {
        return super.getRealStyleFlags() | this._rsflags;
    }

    public String getOuterAttrs() {
        Grid grid;
        StringBuffer sb = new StringBuffer(64).append(super.getOuterAttrs());
        String clkattrs = this.getAllOnClickAttrs();
        if (clkattrs != null) {
            sb.append(clkattrs);
        }
        HTMLs.appendAttribute((StringBuffer)sb, (String)"z.rid", (String)this.getGrid().getUuid());
        HTMLs.appendAttribute((StringBuffer)sb, (String)"align", (String)this._align);
        HTMLs.appendAttribute((StringBuffer)sb, (String)"valign", (String)this._valign);
        HTMLs.appendAttribute((StringBuffer)sb, (String)"z.visible", (boolean)this.isVisible());
        if (this._nowrap) {
            HTMLs.appendAttribute((StringBuffer)sb, (String)"nowrap", (String)"nowrap");
        }
        if ((grid = this.getGrid()) != null && grid.getModel() != null) {
            Component c;
            HTMLs.appendAttribute((StringBuffer)sb, (String)"z.loaded", (boolean)this._loaded);
            if (this._loaded && !grid.inPagingMold() && (c = this.getNextSibling()) instanceof Row && !((Row)c)._loaded) {
                HTMLs.appendAttribute((StringBuffer)sb, (String)"z.skipsib", (String)"true");
            }
        }
        return sb.toString();
    }

    public void setStyle(String style) {
        String s;
        if (style != null && style.length() == 0) {
            style = null;
        }
        if (!Objects.equals((Object)(s = this.getStyle()), (Object)style)) {
            super.setStyle(style);
            this.invalidate();
        }
    }

    public void setSclass(String sclass) {
        String s;
        if (sclass != null && sclass.length() == 0) {
            sclass = null;
        }
        if (!Objects.equals((Object)(s = this.getSclass()), (Object)sclass)) {
            super.setSclass(sclass);
            this.invalidate();
        }
    }

    public String getSclass() {
        String sclass = super.getSclass();
        if (sclass != null) {
            return sclass;
        }
        Grid grid = this.getGrid();
        return grid != null ? grid.getSclass() : sclass;
    }

    public void beforeParentChanged(Component parent) {
        if (parent != null && !(parent instanceof Rows)) {
            throw new UiException("Unsupported parent for row: " + parent);
        }
        super.beforeParentChanged(parent);
    }

    public void beforeChildAdded(Component newChild, Component refChild) {
        if (newChild instanceof org.zkoss.zul.Detail && this._detail != null && this._detail != newChild) {
            throw new UiException("Only one detail is allowed: " + this);
        }
        super.beforeChildAdded(newChild, refChild);
    }

    public boolean insertBefore(Component newChild, Component refChild) {
        if (newChild instanceof org.zkoss.zul.Detail) {
            Component component = refChild = this.getChildren().isEmpty() ? null : (Component)this.getChildren().get(0);
            if (super.insertBefore(newChild, refChild)) {
                this._detail = (org.zkoss.zul.Detail)newChild;
                return true;
            }
            return false;
        }
        if (refChild != null && refChild == this._detail) {
            refChild = this.getChildren().size() <= 1 ? null : (Component)this.getChildren().get(1);
        }
        return super.insertBefore(newChild, refChild);
    }

    public void onChildRemoved(Component child) {
        super.onChildRemoved(child);
        if (this._detail == child) {
            this._detail = null;
        }
    }

    public Object clone() {
        Row clone = (Row)super.clone();
        if (this._detail != null) {
            clone.afterUnmarshal();
        }
        return clone;
    }

    private void afterUnmarshal() {
        Iterator it = this.getChildren().iterator();
        while (it.hasNext()) {
            Object child = it.next();
            if (!(child instanceof org.zkoss.zul.Detail)) continue;
            this._detail = (org.zkoss.zul.Detail)child;
            break;
        }
    }

    private synchronized void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.afterUnmarshal();
    }

    public void onDrawNewChild(Component child, StringBuffer out) throws IOException {
        StringBuffer sb = new StringBuffer(128).append("<td z.type=\"Gcl\" id=\"").append(child.getUuid()).append("!chdextr\"");
        Grid grid = this.getGrid();
        if (grid != null) {
            int j = 0;
            Iterator it = this.getChildren().iterator();
            while (it.hasNext() && child != it.next()) {
                ++j;
            }
            sb.append(this.getChildAttrs(j));
        }
        sb.append("><div id=\"").append(child.getUuid()).append("!cell\"").append(" class=\"").append(this.getZclass()).append("-cnt");
        if (grid.isFixedLayout()) {
            sb.append(" z-overflow-hidden");
        }
        sb.append("\">");
        if (JVMs.isJava5()) {
            out.insert(0, sb);
        } else {
            out.insert(0, sb.toString());
        }
        out.append("</div></td>");
    }
}

