/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul;

import java.io.IOException;
import org.zkoss.lang.JVMs;
import org.zkoss.lang.Objects;
import org.zkoss.xml.HTMLs;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.WrongValueException;
import org.zkoss.zul.Menu;
import org.zkoss.zul.Menuitem;
import org.zkoss.zul.Menuseparator;
import org.zkoss.zul.impl.XulElement;

public class Menubar
extends XulElement
implements org.zkoss.zul.api.Menubar {
    private boolean _autodrop;
    private String _orient = "horizontal";
    private boolean _scrollable = false;

    public Menubar() {
    }

    public Menubar(String orient) {
        this();
        this.setOrient(orient);
    }

    public String getOrient() {
        return this._orient;
    }

    public void setOrient(String orient) throws WrongValueException {
        if (!"horizontal".equals(orient) && !"vertical".equals(orient)) {
            throw new WrongValueException("orient cannot be " + orient);
        }
        if (!Objects.equals((Object)this._orient, (Object)orient)) {
            this._orient = orient;
            this.invalidate();
        }
    }

    public boolean isHorizontal() {
        return "horizontal".equals(this.getOrient());
    }

    public boolean isVertical() {
        return "vertical".equals(this.getOrient());
    }

    public boolean isScrollable() {
        return this._scrollable;
    }

    public void setScrollable(boolean scrollable) {
        if (this.isHorizontal() && this._scrollable != scrollable) {
            this._scrollable = scrollable;
            this.invalidate();
        }
    }

    public final boolean isAutodrop() {
        return this._autodrop;
    }

    public void setAutodrop(boolean autodrop) {
        if (this._autodrop != autodrop) {
            this._autodrop = autodrop;
            this.smartUpdate("z.autodrop", autodrop);
        }
    }

    public String getZclass() {
        return this._zclass == null ? "z-menubar" + ("vertical".equals(this.getOrient()) ? "-ver" : "-hor") : this._zclass;
    }

    public String getOuterAttrs() {
        StringBuffer sb = new StringBuffer(64).append(super.getOuterAttrs());
        if (this._autodrop) {
            HTMLs.appendAttribute((StringBuffer)sb, (String)"z.autodrop", (boolean)this._autodrop);
        }
        if (this.isHorizontal() && this._scrollable) {
            HTMLs.appendAttribute((StringBuffer)sb, (String)"z.scrollable", (boolean)this._scrollable);
        }
        return sb.toString();
    }

    public void onChildAdded(Component child) {
        if (this.isHorizontal() && this._scrollable) {
            this.smartUpdate("z.chchg", true);
        }
        super.onChildAdded(child);
    }

    public void onChildRemoved(Component child) {
        if (this.isHorizontal() && this._scrollable) {
            this.smartUpdate("z.chchg", true);
        }
        super.onChildRemoved(child);
    }

    public void beforeChildAdded(Component child, Component refChild) {
        if (!(child instanceof Menu || child instanceof Menuitem || child instanceof Menuseparator)) {
            throw new UiException("Unsupported child for menubar: " + child);
        }
        super.beforeChildAdded(child, refChild);
    }

    public void onDrawNewChild(Component child, StringBuffer out) throws IOException {
        if ("vertical".equals(this.getOrient())) {
            String height;
            StringBuffer sb = new StringBuffer(32).append("<tr id=\"").append(child.getUuid()).append("!chdextr\"");
            if (child instanceof HtmlBasedComponent && (height = ((HtmlBasedComponent)child).getHeight()) != null) {
                sb.append(" height=\"").append(height).append('\"');
            }
            sb.append('>');
            if (JVMs.isJava5()) {
                out.insert(0, sb);
            } else {
                out.insert(0, sb.toString());
            }
            out.append("</tr>");
        }
    }
}

