/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul.impl;

import org.zkoss.image.Image;
import org.zkoss.lang.Objects;
import org.zkoss.lang.Strings;
import org.zkoss.util.media.Media;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Desktop;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.ext.render.DynamicMedia;
import org.zkoss.zul.impl.LabelElement;

public class LabelImageElement
extends LabelElement {
    private String _src = null;
    private Image _image;
    private int _imgver;

    public String getImage() {
        return this._src;
    }

    public void setImage(String src) {
        if (src != null && src.length() == 0) {
            src = null;
        }
        if (!Objects.equals((Object)this._src, (Object)src)) {
            this._src = src;
            if (this._image == null) {
                this.invalidate();
            }
        }
    }

    public String getSrc() {
        return this.getImage();
    }

    public void setSrc(String src) {
        this.setImage(src);
    }

    public void setImageContent(Image image) {
        if (image != this._image) {
            this._image = image;
            if (this._image != null) {
                ++this._imgver;
            }
            this.invalidate();
        }
    }

    public Image getImageContent() {
        return this._image;
    }

    public boolean isImageAssigned() {
        return this._src != null || this._image != null;
    }

    public String getImgTag() {
        if (this._src == null && this._image == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer(64).append("<img src=\"").append(this._image != null ? this.getContentSrc() : this.getDesktop().getExecution().encodeURL(this._src)).append("\" align=\"absmiddle\"/>");
        String label = this.getLabel();
        if (label != null && label.length() > 0) {
            sb.append(' ');
        }
        return sb.toString();
    }

    private String getContentSrc() {
        Desktop desktop = this.getDesktop();
        if (desktop == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer(64).append('/');
        Strings.encode((StringBuffer)sb, (int)this._imgver);
        String name = this._image.getName();
        String format = this._image.getFormat();
        if (name != null || format != null) {
            sb.append('/');
            boolean bExtRequired = true;
            if (name != null && name.length() != 0) {
                sb.append(name);
                bExtRequired = name.lastIndexOf(46) < 0;
            } else {
                sb.append(this.getId());
            }
            if (bExtRequired && format != null) {
                sb.append('.').append(format);
            }
        }
        return desktop.getDynamicMediaURI((Component)this, sb.toString());
    }

    protected Object newExtraCtrl() {
        return new ExtraCtrl();
    }

    protected class ExtraCtrl
    extends HtmlBasedComponent.ExtraCtrl
    implements DynamicMedia {
        protected ExtraCtrl() {
            super((HtmlBasedComponent)LabelImageElement.this);
        }

        public Media getMedia(String pathInfo) {
            return LabelImageElement.this._image;
        }
    }
}

