/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul;

import java.util.Iterator;
import java.util.List;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zul.Tree;
import org.zkoss.zul.Treechildren;
import org.zkoss.zul.Treecols;
import org.zkoss.zul.Treeitem;
import org.zkoss.zul.Treerow;
import org.zkoss.zul.impl.HeaderElement;

public class Treecol
extends HeaderElement {
    private int _maxlength;

    public Treecol() {
    }

    public Treecol(String label) {
        this.setLabel(label);
    }

    public Treecol(String label, String src) {
        this.setLabel(label);
        this.setSrc(src);
    }

    public Tree getTree() {
        Component comp = this.getParent();
        return comp != null ? (Tree)comp.getParent() : null;
    }

    public int getMaxlength() {
        return this._maxlength;
    }

    public void setMaxlength(int maxlength) {
        if (maxlength < 0) {
            maxlength = 0;
        }
        if (this._maxlength != maxlength) {
            this._maxlength = maxlength;
            this.invalidateCells();
        }
    }

    public int getColumnIndex() {
        int j = 0;
        Iterator it = this.getParent().getChildren().iterator();
        while (it.hasNext() && it.next() != this) {
            ++j;
        }
        return j;
    }

    private void invalidateCells() {
        Tree tree = this.getTree();
        if (tree != null) {
            Treecol.invalidateCells(tree.getTreechildren(), this.getColumnIndex());
        }
    }

    private static void invalidateCells(Treechildren tch, int jcol) {
        if (tch == null) {
            return;
        }
        Iterator it = tch.getChildren().iterator();
        while (it.hasNext()) {
            List chs;
            Treeitem ti = (Treeitem)((Object)it.next());
            Treerow tr = ti.getTreerow();
            if (tr != null && jcol < (chs = tr.getChildren()).size()) {
                ((Component)chs.get(jcol)).invalidate();
            }
            Treecol.invalidateCells(ti.getTreechildren(), jcol);
        }
    }

    public String getOuterAttrs() {
        String attrs = super.getOuterAttrs();
        String clkattrs = this.getAllOnClickAttrs(false);
        return clkattrs == null ? attrs : attrs + clkattrs;
    }

    protected void invalidateWhole() {
        Tree tree = this.getTree();
        if (tree != null) {
            tree.invalidate();
        }
    }

    public void setParent(Component parent) {
        if (parent != null && !(parent instanceof Treecols)) {
            throw new UiException("Wrong parent: " + parent);
        }
        super.setParent(parent);
    }
}

